/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.ConfigurationEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.beans.ReferrerSettings;
import com.atlassian.event.Event;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ManageReferrersAction
extends ConfluenceActionSupport
implements Administrative {
    private String referrerToExclude;
    private String referrerToRemove;
    private String justAdded;
    private boolean showActionMsg;
    private int deletions;
    private static final int MAX_REFERRERS = 20;
    private PaginationSupport paginationSupport = new PaginationSupport(20);
    private long redirPageId;

    public String execute() throws Exception {
        ArrayList excludedReferrers = new ArrayList(this.getReferralSettings().getExcludedReferrers());
        Collections.sort(excludedReferrers);
        this.paginationSupport.setItems(excludedReferrers);
        this.eventManager.publishEvent((Event)new ConfigurationEvent(this));
        return "success";
    }

    public String doDisableReferrers() {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        this.getReferralSettings().setCollectReferrerData(false);
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public String doEnableReferrers() {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        this.getReferralSettings().setCollectReferrerData(true);
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public String doHideReferrers() {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        this.getReferralSettings().setHideExternalReferrers(true);
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public String doShowReferrers() {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        this.getReferralSettings().setHideExternalReferrers(false);
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public String doAddExcludedReferrer() throws Exception {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        if (TextUtils.stringSet((String)this.getReferrerToExclude())) {
            this.getReferralSettings().addReferrer(this.getReferrerToExclude());
        }
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public String doBanReferrerAndRefreshCache() throws Exception {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        if (TextUtils.stringSet((String)this.getReferrerToExclude())) {
            this.getReferralSettings().addReferrer(this.getReferrerToExclude());
        }
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    private void makeSettingsChangedEvent(Settings originalSettings) {
        this.eventManager.publishEvent((Event)new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.settingsManager.getGlobalSettings().getBaseUrl()));
    }

    private ReferrerSettings getReferralSettings() {
        return this.settingsManager.getGlobalSettings().getReferrerSettings();
    }

    public String getReferrerToExclude() {
        return this.referrerToExclude;
    }

    public void setReferrerToExclude(String referrerToExclude) {
        this.referrerToExclude = referrerToExclude;
    }

    public void setReferrerToRemove(String referrerToRemove) {
        this.referrerToRemove = referrerToRemove;
    }

    public String getReferrerToRemove() {
        return this.referrerToRemove;
    }

    public String getJustAdded() {
        return this.justAdded;
    }

    public void setJustAdded(String justAdded) {
        this.justAdded = justAdded;
    }

    public String doRemoveExcludedReferrer() {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        if (TextUtils.stringSet((String)this.getReferrerToRemove())) {
            this.getReferralSettings().removeReferrer(this.getReferrerToRemove());
        }
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.makeSettingsChangedEvent(originalSettings);
        return "success";
    }

    public boolean isHideExternalReferrers() {
        return this.getReferralSettings().isHideExternalReferrers();
    }

    public boolean isCollectReferrerData() {
        return this.getReferralSettings().isCollectReferrerData();
    }

    public List getExcludedReferrers() {
        return this.getReferralSettings().getExcludedReferrers();
    }

    public boolean isShowActionMsg() {
        return this.showActionMsg;
    }

    public void setShowActionMsg(boolean showActionMsg) {
        this.showActionMsg = showActionMsg;
    }

    public int getDeletions() {
        return this.deletions;
    }

    public void setDeletions(int deletions) {
        this.deletions = deletions;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setStartIndex(int start) {
        this.getPaginationSupport().setStartIndex(start);
    }

    public long getRedirPageId() {
        return this.redirPageId;
    }

    public void setRedirPageId(long redirPageId) {
        this.redirPageId = redirPageId;
    }
}

