/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.admin.actions.ViewSystemInfoAction;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.user.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class RaiseSupportRequestAction
extends ViewSystemInfoAction {
    private static final Logger log = Logger.getLogger(RaiseSupportRequestAction.class);
    private static final String TEMPLATE_FILE = "templates/email/text/support-case.vm";
    private ClusterManager clusterManager;
    private PluginAccessor pluginAccessor;
    private ConfluenceSidManager sidManager;
    private MultiQueueTaskManager taskManager;
    private String ccAddresses;
    private String subject;
    private String description;
    private String existingRequest;
    private String contactName;
    private String contactEmail;
    private String contactNumber;
    private List nonSystemPlugins;

    public String doDefault() throws Exception {
        User currentUser = this.getRemoteUser();
        this.setContactName(currentUser.getFullName());
        this.setContactEmail(currentUser.getEmail());
        return super.doDefault();
    }

    public String execute() throws Exception {
        String result = super.execute();
        if (!"success".equals(result)) {
            return result;
        }
        ConfluenceMailQueueItem item = this.createMail();
        this.taskManager.addTask("mail", (Task)item);
        return "success";
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public String getToAddresses() {
        return this.getGlobalSettings().getSupportRequestEmail();
    }

    public String getCcAddresses() {
        return this.ccAddresses;
    }

    public void setCcAddresses(String ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExistingRequest() {
        return this.existingRequest;
    }

    public void setExistingRequest(String existingRequest) {
        this.existingRequest = existingRequest;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public Collection getPlugins() {
        if (this.nonSystemPlugins == null) {
            this.nonSystemPlugins = new ArrayList();
            if (this.pluginAccessor.getPlugins() != null) {
                for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                    if (plugin.isSystemPlugin()) continue;
                    this.nonSystemPlugins.add(plugin);
                }
            }
        }
        Comparator pluginComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Plugin p1 = (Plugin)o1;
                Plugin p2 = (Plugin)o2;
                return p1.getName().compareTo(p2.getName());
            }
        };
        Collections.sort(this.nonSystemPlugins, pluginComparator);
        return this.nonSystemPlugins;
    }

    public boolean isPluginEnabled(String pluginKey) {
        if (this.pluginAccessor == null) {
            return false;
        }
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }

    public boolean isClustered() {
        if (this.clusterManager == null) {
            return false;
        }
        return this.clusterManager.isClustered();
    }

    public String getServerId() {
        if (this.sidManager == null) {
            return null;
        }
        String sid = null;
        try {
            sid = this.sidManager.getSid();
        }
        catch (ConfigurationException ex) {
            log.warn((Object)"Unable to access server Id.", (Throwable)ex);
        }
        return sid;
    }

    public Map getSystemProperties() {
        return System.getProperties();
    }

    public Map getSystemPropertiesHtml() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        char pathSep = File.pathSeparatorChar;
        for (Map.Entry entry : props.entrySet()) {
            String modifiedValue;
            if (((String)entry.getKey()).endsWith(".path")) {
                modifiedValue = (String)entry.getValue();
                entry.setValue(modifiedValue.replace(pathSep, ' '));
                continue;
            }
            if (((String)entry.getKey()).endsWith(".loader")) {
                modifiedValue = (String)entry.getValue();
                entry.setValue(modifiedValue.replace(',', ' '));
                continue;
            }
            if (!((String)entry.getKey()).endsWith(".dirs")) continue;
            modifiedValue = (String)entry.getValue();
            entry.setValue(modifiedValue.replace(pathSep, ' '));
        }
        return props;
    }

    public boolean isMailServerAvailable() {
        SMTPMailServer smtpMailServer = null;
        try {
            smtpMailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
        }
        catch (MailException mex) {
            log.warn((Object)"Could not successfully check for a default mail server.", (Throwable)mex);
        }
        return smtpMailServer != null;
    }

    public void setGc(boolean gc) {
        super.setGc(false);
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setTaskManager(MultiQueueTaskManager tm) {
        this.taskManager = tm;
    }

    ConfluenceMailQueueItem createMail() throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("action", (Object)this);
        String body = VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(TEMPLATE_FILE, (Context)context);
        ConfluenceMailQueueItem item = new ConfluenceMailQueueItem(this.getToAddresses(), this.getCcAddresses(), this.getSubject(), body, "text/plain");
        item.setFromName(this.getContactName());
        item.setFromAddress(this.getContactEmail());
        item.setSendLogs(true);
        AtlassianBootstrapManager atlassianBootstrapManager = BootstrapUtils.getBootstrapManager();
        String logsLocation = atlassianBootstrapManager.getApplicationHome() + File.separator + "logs";
        item.setLogsLocation(logsLocation);
        return item;
    }
}

