/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.status.service.systeminfo.MemoryInfo;
import com.atlassian.confluence.status.service.systeminfo.SystemInfo;
import com.atlassian.plugin.Plugin;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ViewSystemInfoAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Logger logger = Logger.getLogger(ViewSystemInfoAction.class);
    private static final String PROPERTY_PREFIX = "viewsysteminfo";
    private SystemInformationService sysInfoService;
    private ServletContext servletContext;
    private boolean gc = false;

    public ViewSystemInfoAction() {
    }

    public String execute() throws Exception {
        if (this.gc) {
            System.gc();
            Thread.sleep(500L);
        }
        return super.execute();
    }

    public ViewSystemInfoAction(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return ServletActionContext.getServletContext();
    }

    public Map getProps() {
        SystemInfo bean = this.sysInfoService.getSystemProperties();
        if (bean == null) {
            logger.warn((Object)"Cannot retrieve system properties for display.");
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> orderedMap = new LinkedHashMap<String, String>(15);
        orderedMap.put("system.date", bean.getDate());
        orderedMap.put("system.time", bean.getTime());
        orderedMap.put("system.favourite.colour", bean.getFavouriteColour());
        orderedMap.put("java.version", bean.getJavaVersion());
        orderedMap.put("java.vendor", bean.getJavaVendor());
        orderedMap.put("jvm.version", bean.getJvmVersion());
        orderedMap.put("jvm.vendor", bean.getJvmVendor());
        orderedMap.put("jvm.implementation.version", bean.getJvmImplementationVersion());
        orderedMap.put("java.runtime", bean.getJavaRuntime());
        orderedMap.put("java.vm", bean.getJavaVm());
        orderedMap.put("user.name.word", bean.getUserName());
        orderedMap.put("user.timezone", bean.getUserTimezone());
        orderedMap.put("operating.system", bean.getOperatingSystem());
        orderedMap.put("os.architecture", bean.getOperatingSystemArchitecture());
        orderedMap.put("fs.encoding", bean.getFileSystemEncoding());
        return orderedMap;
    }

    public MemoryInfo getMemoryStatistics() {
        MemoryInfo bean = this.sysInfoService.getMemoryInfo();
        if (bean == null) {
            logger.warn((Object)"Cannot retrieve memory statistics for display.");
            bean = new MemoryInfo();
        }
        return bean;
    }

    public Map getBuildStats() {
        ConfluenceInfo bean = this.sysInfoService.getConfluenceInfo();
        if (bean == null) {
            logger.warn((Object)"Cannot retrieve Confluence build properties for display.");
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> buildstats = new LinkedHashMap<String, String>(5);
        buildstats.put("confluence.home", bean.getHome());
        buildstats.put("system.uptime", bean.getUpTime());
        buildstats.put("system.version", bean.getVersion());
        buildstats.put("build.number", bean.getBuildNumber());
        if (bean.isDevMode()) {
            buildstats.put("developer.mode", "Enabled");
        }
        return buildstats;
    }

    public DatabaseInfo getDatabaseInfo() {
        DatabaseInfo bean = this.sysInfoService.getDatabaseInfo();
        if (bean == null) {
            logger.warn((Object)"Cannot retrieve database information for display.");
            bean = new DatabaseInfo();
        }
        return bean;
    }

    public String getDatabaseLatency() {
        Long latency = this.getDatabaseInfo().getExampleLatency();
        String latencyStr = null;
        latencyStr = latency == null ? this.getText("not.available") : latency.toString() + " " + this.getText("milliseconds.short");
        return latencyStr;
    }

    public List getEnabledPlugins() {
        ConfluenceInfo bean = this.sysInfoService.getConfluenceInfo();
        List<Plugin> plugins = null;
        if (bean == null) {
            logger.warn((Object)"Cannot retrieve Confluence plugin information for display.");
            return Collections.EMPTY_LIST;
        }
        plugins = bean.getEnabledPlugins();
        return plugins;
    }

    public void setGc(boolean gc) {
        this.gc = gc;
    }

    public void setSystemInformationService(SystemInformationService sysInfoService) {
        this.sysInfoService = sysInfoService;
    }
}

