/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.cluster;

import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.NodeStatusFactory;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import java.util.List;
import java.util.Map;

public class ClusterConfigurationAction
extends ConfluenceActionSupport {
    private ClusterManager clusterManager;
    private ClusterConfigurationHelper clusterConfigurationHelper;

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    protected ClusterConfigurationHelper getClusterConfigurationHelper() {
        return this.clusterConfigurationHelper;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    public boolean isClusterRunning() {
        return this.clusterManager.getClusterInformation().isRunning();
    }

    public String getClusterStatus() {
        if (this.isClusterRunning()) {
            return this.getText("cluster.status.running");
        }
        return this.getText("cluster.status.not.running");
    }

    private License getLicense() {
        return LicenseManager.getInstance().getLicense("CONF");
    }

    public int getPermittedMemberCount() {
        if (this.getLicense() == null) {
            return 0;
        }
        return this.getLicense().getPermittedClusteredNodes();
    }

    public List getClusterMembers() {
        return this.clusterManager.getClusterInformation().getMembers();
    }

    public String getClusterName() {
        return this.clusterManager.getClusterInformation().getName();
    }

    public String getClusterAddress() {
        return this.clusterManager.getClusterInformation().getMulticastAddress() + ":" + this.clusterManager.getClusterInformation().getMulticastPort();
    }

    public boolean isClusterAddressCorrect() {
        if (!this.clusterManager.isConfigured()) {
            return true;
        }
        String currentAddress = this.clusterManager.getClusterInformation().getMulticastAddress();
        return currentAddress != null && currentAddress.equals(this.clusterManager.resolveName(this.getClusterName()).getHostAddress());
    }

    public Map getDetailedNodeInfo() {
        return NodeStatusFactory.getNodeStatusesForCluster(this.clusterManager);
    }

    public List getClusterableInterfaces() {
        return this.getClusterConfigurationHelper().getClusterableInterfaces();
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

