/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.cluster;

import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class StartClusterTask
extends ConfluenceAbstractLongRunningTask {
    private final JohnsonEventContainer eventContainer;
    private final Event clusterMigrationEvent;
    private String clusterName;
    private String networkInterface;
    private ClusterConfigurationHelper clusterConfigurationHelper;
    private I18NBean i18nBean;

    public StartClusterTask(JohnsonEventContainer eventContainer, Event clusterMigrationEvent, String clusterName, String networkInterface, ClusterConfigurationHelper clusterConfigurationHelper, I18NBean i18nBean) {
        this.eventContainer = eventContainer;
        this.clusterMigrationEvent = clusterMigrationEvent;
        this.clusterName = clusterName;
        this.networkInterface = networkInterface;
        this.clusterConfigurationHelper = clusterConfigurationHelper;
        this.i18nBean = i18nBean;
    }

    public String getName() {
        return "Start Cluster";
    }

    public String getNameKey() {
        return "cluster.start.task.name";
    }

    public void runInternal() {
        try {
            this.progress.setStatus(this.i18nBean.getText("cluster.start.initialising"));
            this.progress.setPercentage(0);
            this.initialiseCluster();
            this.progress.setStatus(this.i18nBean.getText("cluster.start.migrating.attachments"));
            this.migrateAttachmentsToDatabase();
        }
        catch (RuntimeException rte) {
            this.progress.setPercentage(100);
            this.progress.setStatus(this.i18nBean.getText("cluster.start.failed", new String[]{rte.getMessage()}));
            this.progress.setCompletedSuccessfully(false);
            throw rte;
        }
        finally {
            this.eventContainer.removeEvent(this.clusterMigrationEvent);
        }
        Event restartEvent = new Event(JohnsonConfig.getInstance().getEventType("restart"), this.i18nBean.getText("cluster.start.complete"), JohnsonConfig.getInstance().getEventLevel("warning"));
        this.eventContainer.addEvent(restartEvent);
        this.progress.setPercentage(100);
        this.progress.setStatus(this.i18nBean.getText("cluster.start.complete"));
        this.progress.setCompletedSuccessfully(true);
    }

    private void migrateAttachmentsToDatabase() {
        AttachmentManager currentAttachmentManager = (AttachmentManager)ContainerManager.getComponent((String)"attachmentManager");
        AttachmentManager destinationAttachmentManager = (AttachmentManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"databaseAttachmentManager");
        if (currentAttachmentManager.getAttachmentDao().equals(destinationAttachmentManager.getAttachmentDao())) {
            log.warn((Object)"Attachments already stored in database. No migration required");
            return;
        }
        log.info((Object)"Starting attachment migration to database");
        final AttachmentDao.AttachmentMigrator migrator = currentAttachmentManager.getMigrator(destinationAttachmentManager);
        migrator.setProgressMeter(this.progress);
        TransactionTemplate tt = new TransactionTemplate();
        tt.setTransactionManager((PlatformTransactionManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"transactionManager"));
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                migrator.migrate();
                SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
                Settings settings = settingsManager.getGlobalSettings();
                settings.setWebdavServerUrl(null);
                settings.setWebdavUsername(null);
                settings.setWebdavPassword(null);
                settings.setAttachmentDataStore("database.based.attachments.storage");
                settingsManager.updateGlobalSettings(settings);
            }
        });
        log.info((Object)"Attachment migration completed successfully");
    }

    private void initialiseCluster() {
        log.info((Object)("Initialising cluster: " + this.clusterName));
        try {
            this.clusterConfigurationHelper.createCluster(this.clusterName, this.networkInterface);
        }
        catch (ClusterException e) {
            log.error((Object)("There was an error when initialising the cluster: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        log.info((Object)"Cluster initialised successfully");
    }
}

