/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.admin.actions.lookandfeel.AbstractLookAndFeelAction;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityResourceCache;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public abstract class AbstractDecoratorAction
extends AbstractLookAndFeelAction {
    private static final Logger log = Logger.getLogger(AbstractDecoratorAction.class);
    public static final String KLUDGE_WWRESOURCE_TEMPLATE = "decorators/wwloader.vmd";
    public static final String KLUDGE_CLASSPATH_TEMPLATE = "com/atlassian/confluence/cploader.vm";
    String content;
    protected String decoratorName;

    protected String readDefaultTemplate() {
        String templateSource = this.getTemplateFromResourceLoader(KLUDGE_WWRESOURCE_TEMPLATE, this.decoratorName);
        if (templateSource == null) {
            templateSource = this.getTemplateFromResourceLoader(KLUDGE_CLASSPATH_TEMPLATE, this.decoratorName);
        }
        if (templateSource == null) {
            log.warn((Object)("Couldn't load default template source for " + this.decoratorName));
        }
        return templateSource;
    }

    private String getTemplateFromResourceLoader(String knownTemplatePath, String templateToRetrieve) {
        try {
            Template t = VelocityManager.getInstance().getVelocityEngine().getTemplate(knownTemplatePath);
            return this.getTemplateSource(templateToRetrieve, t.getResourceLoader(), t.getEncoding());
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTemplateSource(String template, ResourceLoader resourceLoader, String encoding) {
        String result = "";
        InputStream is = null;
        try {
            String s;
            is = resourceLoader.getResourceStream(template);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            while ((s = br.readLine()) != null) {
                result = result + s + System.getProperty("line.separator");
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            log.warn((Object)"Trouble reading velocity template", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Trouble closing velocity template", (Throwable)e);
                }
            }
        }
    }

    public String getContent() {
        return this.content;
    }

    public String getDecoratorName() {
        return this.decoratorName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDecoratorName(String decoratorName) {
        this.decoratorName = decoratorName;
    }

    protected void removeFromVelocityCache(String decorator) {
        ConfluenceVelocityResourceCache.removeFromCaches(decorator);
    }
}

