/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.themes.DefaultTheme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LayoutHelper;
import java.util.List;

public abstract class AbstractLookAndFeelAction
extends AbstractSpaceAction
implements SpaceAdministrative {
    protected ThemeManager themeManager;
    protected LayoutHelper layoutHelper;
    protected ColourSchemeManager colourSchemeManager;

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        if (this.getSpace() != null) {
            this.addPermissionTypeTo("VIEWSPACE", permissionTypes);
            if (this instanceof SpaceAdministrative) {
                this.addPermissionTypeTo("SETSPACEPERMISSIONS", permissionTypes);
            }
        }
        return permissionTypes;
    }

    public boolean isPermitted() {
        if (!this.getBootstrapManager().isSetupComplete()) {
            return true;
        }
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.spacePermissionManager.hasPermission(this.getPermissionTypes(), this.getSpace(), this.getRemoteUser());
    }

    public boolean isThemeSet() {
        return this.isCustomeThemeSet();
    }

    public boolean isCustomeThemeSet() {
        if (this.getSpace() != null) {
            return this.themeManager.getSpaceTheme(this.getSpace().getKey()) != DefaultTheme.getInstance();
        }
        return this.themeManager.getGlobalTheme() != DefaultTheme.getInstance();
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public void setLayoutHelper(LayoutHelper layoutHelper) {
        this.layoutHelper = layoutHelper;
    }

    public ColourSchemeManager getColourSchemeManager() {
        return this.colourSchemeManager;
    }

    public void setColourSchemeManager(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }
}

