/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.admin.actions.lookandfeel.LookAndFeelAction;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.util.LayoutHelper;
import com.atlassian.confluence.util.misc.CssColourValidator;
import com.opensymphony.webwork.ServletActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ColourSchemeAction
extends LookAndFeelAction {
    private static final Logger log = Logger.getLogger(ColourSchemeAction.class);
    private boolean resetDefaults;
    private Map colourMap = new HashMap();

    public String execute() throws ConfigurationException {
        if (this.resetDefaults) {
            return this.doReset();
        }
        this.getColourSchemeType();
        this.validateAndPopulateColourScheme();
        if (this.getFieldErrors().isEmpty() && this.getActionErrors().isEmpty()) {
            this.convertMapToScheme();
            if (this.getSpace() != null) {
                this.colourSchemeManager.saveSpaceColourScheme(this.getSpace(), this.getEditableColourScheme());
            } else {
                this.colourSchemeManager.saveGlobalColourScheme(this.getEditableColourScheme());
            }
            LayoutHelper.flushThemeComponents(this.getSpaceKey());
            return "success";
        }
        return "error";
    }

    public String changeColorScheme() {
        this.setColourSchemeSetting();
        LayoutHelper.flushThemeComponents(this.getSpaceKey());
        return "success";
    }

    public String doDefault() throws Exception {
        this.convertSchemeToMap();
        return super.doDefault();
    }

    public String getColour(String key) {
        return this.getEditableColourScheme().get(key);
    }

    public Map getColourMap() {
        return this.colourMap;
    }

    private String doReset() {
        this.colourSchemeManager.resetColourScheme(this.getSpace());
        LayoutHelper.flushThemeComponents(this.getSpaceKey());
        return "reset";
    }

    public void setResetDefaults(String resetDefaults) {
        this.resetDefaults = resetDefaults != null && resetDefaults.length() != 0;
    }

    private void validateAndPopulateColourScheme() {
        for (String colourKey : ColourScheme.ORDERED_KEYS) {
            if (CssColourValidator.check(this.getFromColourMap(colourKey))) continue;
            this.addColourError(this.getFromColourMap(colourKey));
        }
    }

    private String getFromColourMap(String key) {
        String[] values = (String[])this.colourMap.get(key);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private void addColourError(String value) {
        this.addActionError(this.getText("colour.notvalid", new String[]{value}));
    }

    private void convertSchemeToMap() {
        for (String colourKey : ColourScheme.ORDERED_KEYS) {
            this.colourMap.put(colourKey, this.getEditableColourScheme().get(colourKey));
        }
    }

    private void convertMapToScheme() {
        for (String colourKey : ColourScheme.ORDERED_KEYS) {
            if (this.getEditableColourScheme() instanceof BaseColourScheme) {
                this.getEditableColourScheme().set(colourKey, this.getFromColourMap(colourKey));
                continue;
            }
            log.error((Object)"Trying to modify a non-editable colour scheme.");
        }
    }

    private void setColourSchemeSetting() {
        Map parameterMap = ServletActionContext.getRequest().getParameterMap();
        for (int i = 0; i < this.layoutHelper.getColourSchemeTypes().size(); ++i) {
            String key = (String)this.layoutHelper.getColourSchemeTypes().get(i);
            if (!parameterMap.containsKey(key)) continue;
            this.colourSchemeManager.setColourSchemeSetting(this.getSpace(), key);
        }
    }
}

