/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.Event;

public class CustomHtmlAction
extends ConfluenceActionSupport
implements LookAndFeel {
    private CustomHtmlSettings customHtmlSettings = new CustomHtmlSettings();

    public String doDefault() throws Exception {
        this.customHtmlSettings = new CustomHtmlSettings(this.settingsManager.getGlobalSettings().getCustomHtmlSettings());
        return super.doDefault();
    }

    public String execute() throws Exception {
        Settings settings = this.settingsManager.getGlobalSettings();
        settings.setCustomHtmlSettings(this.customHtmlSettings);
        this.settingsManager.updateGlobalSettings(settings);
        this.makeSettingsChangedEvent(settings);
        return super.execute();
    }

    public CustomHtmlSettings getCustomHtmlSettings() {
        return this.customHtmlSettings;
    }

    private void makeSettingsChangedEvent(Settings originalSettings) {
        this.eventManager.publishEvent((Event)new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.settingsManager.getGlobalSettings().getBaseUrl()));
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

