/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.admin.actions.lookandfeel.AbstractDecoratorAction;
import com.atlassian.confluence.admin.actions.lookandfeel.DefaultDecorator;
import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.themes.persistence.PersistentDecoratorDao;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class EditDecoratorAction
extends AbstractDecoratorAction
implements LookAndFeel {
    private DefaultDecorator defaultDecorator;
    private PersistentDecoratorDao persistentDecoratorDao;

    public List getDecorators() {
        return DefaultDecorator.getDecorators();
    }

    public String doList() {
        return "input";
    }

    public boolean hasTemplate(String decoratorName) {
        return this.persistentDecoratorDao.get(this.getSpaceKey(), decoratorName) != null;
    }

    public DefaultDecorator getDefaultDecorator() {
        if (this.defaultDecorator == null && TextUtils.stringSet((String)this.decoratorName)) {
            this.defaultDecorator = DefaultDecorator.getByFileName(this.decoratorName);
        }
        return this.defaultDecorator;
    }

    public String doRead() {
        if (this.getDefaultDecorator() == null) {
            this.addActionError(this.getText("template.notfound", new String[]{this.decoratorName}));
            return "error";
        }
        PersistentDecorator decorator = this.getPersistentDecorator();
        if (decorator == null) {
            this.content = this.readDefaultTemplate();
            if (this.content == null) {
                this.addActionError(this.getText("template.notfound", new Object[]{this.decoratorName}));
            }
        } else {
            this.content = decorator.getBody();
        }
        return "input";
    }

    private PersistentDecorator getPersistentDecorator() {
        return this.persistentDecoratorDao.get(this.getSpaceKey(), this.getDecoratorName());
    }

    public String doWrite() throws Exception {
        if (this.getDefaultDecorator() == null) {
            this.addActionError("error.decorator.not.found");
            return "error";
        }
        PersistentDecorator decorator = new PersistentDecorator();
        decorator.setSpaceKey(this.getSpaceKey());
        decorator.setName(this.getDecoratorName());
        decorator.setBody(this.getContent());
        this.persistentDecoratorDao.saveOrUpdate(decorator);
        this.removeFromVelocityCache(this.getDecoratorName());
        return "success";
    }

    public String doReset() throws Exception {
        PersistentDecorator decorator = this.getPersistentDecorator();
        if (decorator == null) {
            this.addActionError(this.getText("template.notfound", this.decoratorName));
            return "input";
        }
        this.persistentDecoratorDao.remove(decorator);
        this.removeFromVelocityCache(this.decoratorName);
        return "success";
    }

    public void setPersistentDecoratorDao(PersistentDecoratorDao persistentDecoratorDao) {
        this.persistentDecoratorDao = persistentDecoratorDao;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

