/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.mail;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SendTestEmailAction
extends ConfluenceActionSupport {
    private Long id;
    private String to;
    private String subject;
    private String messageType;
    private String message;
    private String logMessage;

    public String doDefault() throws Exception {
        String from = null;
        String servername = null;
        String username = null;
        SMTPMailServer mailserver = this.getSmtpMailServer();
        from = mailserver.getDefaultFrom();
        servername = mailserver.getName();
        username = mailserver.getUsername();
        this.setMessage("This is a test message from Confluence. \nServer: " + servername + "\nFrom: " + from + "\nHost User Name: " + username);
        this.setSubject("Test Message From Confluence");
        this.setMessageType("text");
        this.setTo(this.getRemoteUser().getEmail());
        return "input";
    }

    public String execute() throws Exception {
        try {
            Email mail = new Email(this.to);
            mail.setBody(this.message);
            mail.setSubject(this.subject);
            if ("html".equals(this.getMessageType())) {
                mail.setMimeType("text/html");
            }
            this.getSmtpMailServer().send(mail);
        }
        catch (Exception e) {
            this.logMessage = "An error has occurred with sending the test email:\n" + ExceptionUtils.getStackTrace((Throwable)e);
            return "input";
        }
        this.logMessage = "Your test message has been sent successfully to " + this.to + ".";
        return "input";
    }

    public Map getMimeTypes() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("html", "Html");
        result.put("text", "Text");
        return result;
    }

    private SMTPMailServer getSmtpMailServer() throws MailException {
        return (SMTPMailServer)MailFactory.getServerManager().getMailServer(this.getId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLog() {
        return this.logMessage;
    }
}

