/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.mail;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.mail.template.MailNotificationQueueItem;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueueWithErrorQueue;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ViewMailQueueAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Logger log = Logger.getLogger(ViewMailQueueAction.class);
    private String page = "";
    private TaskQueueWithErrorQueue queue;

    public TaskQueueWithErrorQueue getMailQueue() {
        return this.queue;
    }

    public String doFlush() {
        log.debug((Object)"Flushing mail queue ...");
        if (!this.getMailQueue().isFlushing()) {
            log.debug((Object)"Sending queue...");
            this.getMailQueue().flush();
        } else {
            log.debug((Object)"Queue was sending - skipped mail flush this time.");
        }
        return "success";
    }

    public String doResend() {
        Collection errorItems = this.getMailQueue().getErrorQueue().getTasks();
        for (MailNotificationQueueItem errorItem : errorItems) {
            this.getMailQueue().addTask((Task)errorItem);
        }
        this.doDeleteErrorQueue();
        this.getMailQueue().flush();
        return "success";
    }

    public String doDeleteErrorQueue() {
        this.getMailQueue().getErrorQueue().clear();
        return "success";
    }

    public String doDeleteQueue() {
        this.getMailQueue().clear();
        return "success";
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setMailTaskQueue(TaskQueueWithErrorQueue queue) {
        this.queue = queue;
    }
}

