/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.plugins;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.FilePluginJar;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginJar;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.interceptor.SessionAware;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManagePluginsAction
extends ConfluenceActionSupport
implements SessionAware {
    private static final Logger log = Logger.getLogger(ManagePluginsAction.class);
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    protected Plugin selectedPlugin;
    private String mode;
    private String pluginKey;
    protected String moduleKey;
    private Map session;
    private List nonSystemPlugins;
    private Integer newPlugins;
    private static final String PLUGIN_REPOSITORY_KEY = "confluence.repository.client";
    private boolean uninstallSuccessful;

    public String execute() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Plugin operation: " + this.mode + " attempted by " + this.getRemoteUser() + "."));
        }
        this.updateSelectedPlugin();
        if (("disable".equalsIgnoreCase(this.mode) || "enable".equalsIgnoreCase(this.mode)) && this.isSystemPlugin()) {
            this.addActionError(this.getText("error.cannot.modify.system.plugins"));
            return super.execute();
        }
        if ("disable".equalsIgnoreCase(this.mode)) {
            if (TextUtils.stringSet((String)this.moduleKey)) {
                this.pluginController.disablePluginModule(this.moduleKey);
            } else if (TextUtils.stringSet((String)this.pluginKey)) {
                this.pluginController.disablePlugin(this.pluginKey);
            }
        } else if ("enable".equalsIgnoreCase(this.mode)) {
            if (TextUtils.stringSet((String)this.moduleKey)) {
                this.pluginController.enablePluginModule(this.moduleKey);
            } else if (TextUtils.stringSet((String)this.pluginKey)) {
                this.pluginController.enablePlugin(this.pluginKey);
            }
        } else if ("rescan".equalsIgnoreCase(this.mode)) {
            this.newPlugins = new Integer(this.pluginController.scanForNewPlugins());
        } else if ("uninstall".equalsIgnoreCase(this.mode) && this.selectedPlugin != null) {
            if (!this.selectedPlugin.isUninstallable()) {
                this.addActionError(this.getText("error.plugin.not.uninstallable"));
            } else {
                try {
                    this.pluginController.uninstall(this.selectedPlugin);
                    this.uninstallSuccessful = true;
                }
                catch (PluginException e) {
                    this.addActionError(this.getText("error.uninstalling.plugin.view.logs"));
                    this.uninstallSuccessful = false;
                    log.error((Object)e, (Throwable)e);
                }
                this.selectedPlugin = null;
            }
        }
        return super.execute();
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    private boolean isSystemPlugin() {
        if (TextUtils.stringSet((String)this.pluginKey)) {
            return this.pluginAccessor.isSystemPlugin(this.pluginKey);
        }
        if (this.moduleKey != null && this.moduleKey.indexOf(58) > 0) {
            return this.pluginAccessor.isSystemPlugin(this.moduleKey.substring(0, this.moduleKey.indexOf(58)));
        }
        return false;
    }

    protected void updateSelectedPlugin() {
        if (TextUtils.stringSet((String)this.pluginKey)) {
            this.selectedPlugin = this.pluginAccessor.getPlugin(this.pluginKey);
            this.session.put("confluence.admin.selected.plugin", this.pluginKey);
        } else if (this.pluginAccessor.getPlugins().size() > 0) {
            if (this.session.get("confluence.admin.selected.plugin") != null) {
                this.selectedPlugin = this.pluginAccessor.getPlugin((String)this.session.get("confluence.admin.selected.plugin"));
            }
            if (this.selectedPlugin == null) {
                this.selectedPlugin = (Plugin)this.pluginAccessor.getPlugins().iterator().next();
            }
        }
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Collection getPlugins() {
        if (this.nonSystemPlugins == null) {
            this.nonSystemPlugins = new ArrayList();
            if (this.pluginAccessor.getPlugins() != null) {
                for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                    if (plugin.isSystemPlugin()) continue;
                    this.nonSystemPlugins.add(plugin);
                }
            }
        }
        Comparator pluginComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Plugin p1 = (Plugin)o1;
                Plugin p2 = (Plugin)o2;
                return p1.getName().compareTo(p2.getName());
            }
        };
        Collections.sort(this.nonSystemPlugins, pluginComparator);
        return this.nonSystemPlugins;
    }

    public boolean isUnloadablePlugin(Plugin plugin) {
        return plugin.getClass().equals(UnloadablePlugin.class);
    }

    public boolean isPluginEnabled(String pluginKey) {
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }

    public boolean isUnloadableModule(ModuleDescriptor descriptor) {
        return descriptor.getClass().equals(UnloadableModuleDescriptor.class);
    }

    public boolean isUnrecognisedModule(ModuleDescriptor descriptor) {
        return descriptor.getClass().equals(UnrecognisedModuleDescriptor.class);
    }

    public boolean isModuleEnabled(String moduleKey) {
        return this.pluginAccessor.isPluginModuleEnabled(moduleKey);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public void setModuleKey(String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public Plugin getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public int numEnabled(Plugin plugin) {
        int count = 0;
        Iterator iterator = plugin.getModuleDescriptors().iterator();
        while (iterator.hasNext()) {
            if (!this.pluginAccessor.isPluginModuleEnabled(((ModuleDescriptor)iterator.next()).getCompleteKey())) continue;
            ++count;
        }
        return count;
    }

    protected String installPlugin(File pluginJar) throws PluginParseException {
        return this.pluginController.installPlugin((PluginJar)new FilePluginJar(pluginJar));
    }

    protected String installPlugin(File pluginJar, final String pluginFileName) throws PluginParseException {
        return this.pluginController.installPlugin((PluginJar)new FilePluginJar(pluginJar){

            public String getFileName() {
                return pluginFileName;
            }
        });
    }

    public Integer getNewPlugins() {
        return this.newPlugins;
    }

    public void setSession(Map session) {
        this.session = session;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public boolean isPluginRepositoryEnabled() {
        return this.pluginAccessor.isPluginEnabled(PLUGIN_REPOSITORY_KEY);
    }

    public boolean isUninstallSuccessful() {
        return this.uninstallSuccessful;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

