/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache;

import com.atlassian.cache.Cache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class CacheOperations {
    private static final Category log = Category.getInstance(CacheOperations.class);
    private Map putOperations = new HashMap();
    private Set removeOperations = new HashSet();

    public Object get(Object key) {
        return this.putOperations.get(key);
    }

    public boolean isRemoved(Object key) {
        return this.removeOperations.contains(key);
    }

    public void put(Object key, Object value) {
        this.putOperations.put(key, value);
        this.removeOperations.remove(key);
    }

    public void remove(Object key) {
        this.removeOperations.add(key);
        this.putOperations.remove(key);
    }

    public void removeAll(Collection keys) {
        this.removeOperations.addAll(keys);
        this.putOperations.keySet().removeAll(keys);
    }

    public void clear() {
        this.removeOperations.clear();
        this.putOperations.clear();
    }

    public Set filter(Collection keys) {
        HashSet result = new HashSet();
        if (keys != null) {
            result.addAll(keys);
        }
        result.addAll(this.putOperations.keySet());
        result.removeAll(this.removeOperations);
        return result;
    }

    public void perform(Cache cache) {
        for (Map.Entry entry : this.putOperations.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting entry " + entry));
            }
            cache.put(entry.getKey(), entry.getValue());
        }
        for (Object key : this.removeOperations) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing key " + key));
            }
            cache.remove(key);
        }
    }

    public int putCount() {
        return this.putOperations.size();
    }

    public int removeCount() {
        return this.removeOperations.size();
    }
}

