/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache;

import com.atlassian.cache.Cache;
import com.atlassian.confluence.cache.CacheAdapter;
import com.atlassian.confluence.cache.CacheOperations;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Category;

public class DeferredOperationsCache
extends CacheAdapter {
    private static final Category log = Category.getInstance(DeferredOperationsCache.class);
    private final CacheOperations cacheOperations = new CacheOperations();

    public DeferredOperationsCache(Cache delegate) {
        super(delegate);
    }

    public Object get(Object key) {
        Object value;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving [" + key + "] from cache [" + this.getName() + "]"));
        }
        if ((value = this.cacheOperations.get(key)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found thread bound value: " + value));
            }
            return value;
        }
        if (this.cacheOperations.isRemoved(key)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Value has been removed in current transaction");
            }
            return null;
        }
        return super.get(key);
    }

    public Collection getKeys() {
        return new ArrayList(this.cacheOperations.filter(super.getKeys()));
    }

    public void put(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Deferring addition of key [{0}]; value [{1}] to cache [{2}]", key, value, this.getName()));
        }
        this.cacheOperations.put(key, value);
    }

    public void remove(Object key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Deferring removal of key [{0}]; from cache [{1}]", key, this.getName()));
        }
        this.cacheOperations.remove(key);
    }

    public void removeAll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Deferring removal of all keys from cache [{0}]", this.getName()));
        }
        this.cacheOperations.removeAll(this.getKeys());
    }

    public void sync() {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Synchronising deferred operations ({0} put, {1} remove) to cache [{2}]", new Integer(this.cacheOperations.putCount()), new Integer(this.cacheOperations.removeCount()), this.getName()));
        }
        this.cacheOperations.perform(this.getDelegate());
        this.cacheOperations.clear();
    }
}

