/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CacheAdapter;
import com.atlassian.confluence.cache.DeferredOperationsCache;
import com.atlassian.confluence.cache.ReadThroughCacheFactory;
import com.atlassian.confluence.cache.WarnBeforeMethodAdvice;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.concurrent.LockFactory;
import com.atlassian.confluence.concurrent.LockOperationWithoutResult;
import com.atlassian.confluence.concurrent.ResettableThreadLocal;
import com.atlassian.confluence.concurrent.ThreadLocalMap;
import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.util.AopUtils;
import java.text.MessageFormat;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.apache.log4j.Category;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class TransactionalCacheFactory
implements LockFactory,
ReadThroughCacheFactory {
    private static final ResettableThreadLocal transactionalCacheMapThreadLocal = new ThreadLocalMap();
    private static final String LOCK_NAMESPACE = "com.atlassian.confluence.cache.transaction.";
    private static final Category log = Category.getInstance(TransactionalCacheFactory.class);
    private static final NameMatchMethodPointcutAdvisor cacheUpdateLoggingAdvisor = new NameMatchMethodPointcutAdvisor();
    private final CacheFactory cacheFactory;
    private final LockFactory lockFactory;
    private final SynchronizationManager synchronizationManager;
    private final DelegateCacheSynchronization synchronization = new DelegateCacheSynchronization();

    public TransactionalCacheFactory(CacheFactory cacheFactory, LockFactory lockFactory, SynchronizationManager synchronizationManager) {
        this.cacheFactory = cacheFactory;
        this.lockFactory = lockFactory;
        this.synchronizationManager = synchronizationManager;
    }

    public Cache getCache(String cacheName) {
        if (!this.synchronizationManager.isTransactionActive()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No transaction active; returning non-transactional cache");
            }
            return this.proxyCacheWithUpdateLogging(this.cacheFactory.getCache(cacheName));
        }
        return this.getTransactionalCache(cacheName);
    }

    private void bindCacheSynchronizationIfNecessary() {
        if (!this.getTransactionCacheMap().isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering transactional cache synchronization for thread: " + Thread.currentThread().getName()));
        }
        this.synchronizationManager.registerSynchronization((TransactionSynchronization)this.synchronization);
    }

    public Cache getReadThroughCacheForUpdate(String cacheName) {
        return new PutLockingCache(this.cacheFactory.getCache(cacheName), this.getLock(cacheName));
    }

    private Cache proxyCacheWithUpdateLogging(Cache cache) {
        try {
            return (Cache)AopUtils.createAdvisedProxy(cache, (Advisor)cacheUpdateLoggingAdvisor, Cache.class);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not create logging advised cache", (Throwable)ex);
            return cache;
        }
    }

    private Cache getTransactionalCache(String cacheName) {
        Cache transactionalCache;
        if (this.getTransactionCacheMap().get(cacheName) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pre-bound transactional cache found for cache name: " + cacheName));
            }
            transactionalCache = (Cache)this.getTransactionCacheMap().get(cacheName);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Binding new transactional cache to thread local: " + cacheName));
            }
            transactionalCache = new DeferredOperationsCache(this.cacheFactory.getCache(cacheName));
            this.bindCacheSynchronizationIfNecessary();
            this.getTransactionCacheMap().put(cacheName, transactionalCache);
        }
        return transactionalCache;
    }

    public Lock getLock(String cacheName) {
        return this.lockFactory.getLock(LOCK_NAMESPACE + cacheName);
    }

    private Map getTransactionCacheMap() {
        return (Map)transactionalCacheMapThreadLocal.get();
    }

    private void unbindCaches() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unbinding transactional caches for thread: " + Thread.currentThread().getName()));
        }
        transactionalCacheMapThreadLocal.reset();
    }

    static {
        cacheUpdateLoggingAdvisor.setAdvice((Advice)new WarnBeforeMethodAdvice(log, new MessageFormat("Transactional cache update outside transaction. All updates to this cache should be performed from a thread with a valid transaction context.")));
        cacheUpdateLoggingAdvisor.setMappedNames(new String[]{"remove", "put", "removeAll"});
    }

    private class PutLockingCache
    extends CacheAdapter {
        private final Lock lock;

        public PutLockingCache(Cache cache, Lock lock) {
            super(cache);
            this.lock = lock;
        }

        public void put(final Object key, final Object value) {
            new LockOperationWithoutResult(this.lock){

                protected void withLockNoResult() {
                    PutLockingCache.this.doPut(key, value);
                }
            }.run();
        }

        private void doPut(Object key, Object value) {
            super.put(key, value);
        }
    }

    class DelegateCacheSynchronization
    extends TransactionSynchronizationAdapter {
        DelegateCacheSynchronization() {
        }

        public int getOrder() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Performing after transaction completion tasks");
                }
                if (status != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Transaction was not committed; cache changes not performed");
                    }
                    return;
                }
                this.synchronizeCaches();
            }
            finally {
                TransactionalCacheFactory.this.unbindCaches();
            }
        }

        private void synchronizeCaches() {
            Map cacheMap = TransactionalCacheFactory.this.getTransactionCacheMap();
            for (Map.Entry nameToCacheEntry : cacheMap.entrySet()) {
                String cacheName = (String)nameToCacheEntry.getKey();
                DeferredOperationsCache cache = (DeferredOperationsCache)nameToCacheEntry.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Synchronizing transactional cache: " + cacheName));
                }
                try {
                    this.synchronizeCache(TransactionalCacheFactory.this.getLock(cacheName), cache);
                }
                catch (Exception e) {
                    this.handleCacheSynchronizationFailure(cacheName, e);
                }
                catch (LinkageError e) {
                    this.handleCacheSynchronizationFailure(cacheName, e);
                }
            }
        }

        private void handleCacheSynchronizationFailure(String cacheName, Throwable e) {
            log.error((Object)("Could not synchronise transactional cache [" + cacheName + "]. Attempting flush instead."), e);
            TransactionalCacheFactory.this.cacheFactory.getCache(cacheName).removeAll();
        }

        private void synchronizeCache(final Lock lock, final DeferredOperationsCache cache) {
            new LockOperationWithoutResult(lock){

                protected void withLockNoResult() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Performing cache update operations under lock " + lock));
                    }
                    cache.sync();
                }
            }.run();
        }
    }
}

