/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.tangosol;

import com.atlassian.confluence.cache.tangosol.TangosolCacheFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MultiplexingMapListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListenerTangosolCacheFactory
implements TangosolCacheFactory {
    private static final Logger log = Logger.getLogger(ListenerTangosolCacheFactory.class);
    private static final MultiplexingMapListener loggingListener = new MultiplexingMapListener(){

        protected void onMapEvent(MapEvent event) {
            log.debug((Object)(event.getSource() + ": " + event));
        }
    };
    private static final MapListener integrityCheckListener = new MapListener(){

        public void entryUpdated(MapEvent event) {
        }

        public void entryDeleted(MapEvent event) {
        }

        public void entryInserted(MapEvent event) {
            Object o2;
            Object o1 = event.getKey();
            if (!o1.equals(o2 = ExternalizableHelper.fromBinary((Binary)ExternalizableHelper.toBinary((Object)o1))) || o1.hashCode() != o2.hashCode()) {
                log.error((Object)("Broken cache key: " + event.getSource() + ", " + o1));
            }
        }
    };
    private Set cachesWithListeners = new HashSet();

    public NamedCache getCache(String cacheName) {
        return this.getCache(cacheName, null);
    }

    public NamedCache getCache(String cacheName, ClassLoader classLoader) {
        NamedCache cache;
        if (log.isDebugEnabled()) {
            log.debug((Object)cacheName);
        }
        if ((cache = classLoader == null ? CacheFactory.getCache((String)cacheName) : CacheFactory.getCache((String)cacheName, (ClassLoader)classLoader)) == null) {
            throw new RuntimeException("Could not create cache named: " + cacheName);
        }
        if (log.isDebugEnabled()) {
            this.addDebugListeners(cacheName, cache);
        }
        return cache;
    }

    private void addDebugListeners(String cacheName, NamedCache cache) {
        if (this.cachesWithListeners.contains(cacheName)) {
            return;
        }
        this.cachesWithListeners.add(cacheName);
        cache.addMapListener((MapListener)loggingListener);
        cache.addMapListener(integrityCheckListener);
    }
}

