/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster;

import com.atlassian.confluence.cluster.InvalidClusterAddressException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.MessageFormat;

public class ClusterConfig {
    private InetAddress address;
    private String clusterName;
    private int timeToLive;
    private NetworkInterface networkInterface;

    public ClusterConfig(InetAddress address, String clusterName, int timeToLive) throws InvalidClusterAddressException {
        if (!address.isMulticastAddress()) {
            throw new InvalidClusterAddressException("Cluster configurations must use a valid multicast address", address);
        }
        this.address = address;
        this.clusterName = clusterName;
        this.timeToLive = timeToLive;
    }

    public ClusterConfig(InetAddress address, String clusterName, int timeToLive, NetworkInterface iface) throws InvalidClusterAddressException {
        this(address, clusterName, timeToLive);
        this.networkInterface = iface;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public InetAddress getUnicastAddress() {
        if (this.getNetworkInterface() == null) {
            return null;
        }
        return this.getNetworkInterface().getInetAddresses().nextElement();
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public String toString() {
        return MessageFormat.format("ClusterConfig: {0}/{1}, TTL:{2}, Interface:{3}", this.clusterName, this.address.getHostAddress(), new Integer(this.timeToLive), this.networkInterface);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConfig that = (ClusterConfig)o;
        if (this.timeToLive != that.timeToLive) {
            return false;
        }
        if (!this.address.equals(that.address)) {
            return false;
        }
        if (!this.clusterName.equals(that.clusterName)) {
            return false;
        }
        return !(this.networkInterface != null ? !this.networkInterface.equals(that.networkInterface) : that.networkInterface != null);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + this.timeToLive;
        result = 31 * result + (this.networkInterface != null ? this.networkInterface.hashCode() : 0);
        return result;
    }
}

