/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.safety;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.safety.ClusterPanicEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.EventListener;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import javax.servlet.ServletContext;
import org.apache.log4j.Category;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class ClusterPanicListener
implements EventListener {
    private static final Category log = Category.getInstance(ClusterPanicListener.class);
    private ClusterManager clusterManager;
    private Scheduler scheduler;

    public void handleEvent(com.atlassian.event.Event event) {
        ClusterPanicEvent panicEvent;
        if (System.getProperty("confluence.panic.disable") != null) {
            return;
        }
        if (event instanceof ClusterEventWrapper) {
            com.atlassian.event.Event wrappedEvent = ((ClusterEventWrapper)event).getEvent();
            if (!(wrappedEvent instanceof ClusterPanicEvent)) {
                return;
            }
            panicEvent = (ClusterPanicEvent)wrappedEvent;
        } else if (event instanceof ClusterPanicEvent) {
            panicEvent = (ClusterPanicEvent)event;
        } else {
            return;
        }
        log.fatal((Object)("Fatal error in Confluence cluster: " + panicEvent.getDescription()));
        log.info((Object)this.clusterManager.getClusterInformation());
        this.getJohnsonEventContainer().addEvent(this.createPanicJohnsonEvent(panicEvent.getDescription()));
        log.info((Object)"Shutting down Quartz scheduler");
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.error((Object)"Error shutting down Quartz scheduler. Database consistency may be at risk. Shut down Confluence as soon as possible and fix above clustering errors.", (Throwable)e);
        }
    }

    private Event createPanicJohnsonEvent(String message) {
        return new Event(JohnsonConfig.getInstance().getEventType("cluster"), message, JohnsonConfig.getInstance().getEventLevel("fatal"));
    }

    private JohnsonEventContainer getJohnsonEventContainer() {
        SpringContainerContext containerContext = (SpringContainerContext)ContainerManager.getInstance().getContainerContext();
        return JohnsonEventContainer.get((ServletContext)containerContext.getServletContext());
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ClusterEventWrapper.class, ClusterPanicEvent.class};
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

