/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.safety;

import com.atlassian.confluence.cluster.safety.ClusterSafetyDao;
import com.atlassian.confluence.cluster.safety.ClusterSafetyNumber;
import java.util.List;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateClusterSafetyDao
extends HibernateDaoSupport
implements ClusterSafetyDao {
    public int getSafetyNumber() {
        return this.getClusterSafetyNumberObject().getSafetyNumber();
    }

    public boolean safetyNumberExists() {
        return !this.findSafetyNumberData().isEmpty();
    }

    public void setSafetyNumber(int safetyNumber) {
        ClusterSafetyNumber clusterSafetyNumber = this.safetyNumberExists() ? this.getClusterSafetyNumberObject() : new ClusterSafetyNumber();
        clusterSafetyNumber.setSafetyNumber(safetyNumber);
        this.getHibernateTemplate().save((Object)clusterSafetyNumber);
    }

    private ClusterSafetyNumber getClusterSafetyNumberObject() {
        List results = this.findSafetyNumberData();
        if (results.isEmpty()) {
            throw new RuntimeException("Cluster safety number not found.");
        }
        if (results.size() > 1) {
            throw new RuntimeException("More than one cluster safety number in database.");
        }
        return (ClusterSafetyNumber)results.get(0);
    }

    private List findSafetyNumberData() {
        return this.getHibernateTemplate().findByNamedQuery("confluence.csn_getClusterSafetyNumber");
    }
}

