/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.tangosol;

import com.atlassian.config.ApplicationConfig;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.ClusteredLock;
import com.atlassian.confluence.cluster.EmptyClusterInformation;
import com.atlassian.confluence.cluster.HashClusterNameResolver;
import com.atlassian.confluence.cluster.NameResolver;
import com.atlassian.confluence.cluster.tangosol.TangosolClusterInformation;
import com.atlassian.confluence.cluster.tangosol.TangosolClusterNodeInformation;
import com.atlassian.confluence.cluster.tangosol.TangosolClusteredFifoBuffer;
import com.atlassian.confluence.cluster.tangosol.TangosolClusteredLock;
import com.atlassian.confluence.cluster.tangosol.invocations.EventInvocable;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.setup.SharedConfigurationMap;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.task.FifoBuffer;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.log4j.Category;

public class TangosolClusterManager
implements ClusterManager,
NameResolver {
    protected static final Category log = Category.getInstance(TangosolClusterManager.class);
    private static final String PUBLISHED_CACHE_NAME = "com.atlassian.confluence.published-cache";
    private static final String LOCK_CACHE_NAME = "com.atlassian.confluence.lock-cache";
    private static final String COHERENCE_DEFAULTS = "tangosol-coherence.xml";
    private static final String OVERRIDE_FILE_NAME = "tangosol-coherence-override.xml";
    private static final MemberEventLogger MEMBER_EVENT_LOGGER = new MemberEventLogger();
    private NameResolver clusterNameResolver = new HashClusterNameResolver();
    private final ApplicationConfig applicationConfig;
    private final SynchronizationManager synchronizationManager;
    private ClusterInformation clusterInformation;
    private final ClassLoader applicationClassLoader;

    public TangosolClusterManager(ApplicationConfig applicationConfig, ClassLoader applicationClassLoader, SynchronizationManager synchronizationManager) {
        this.applicationConfig = applicationConfig;
        this.applicationClassLoader = applicationClassLoader;
        this.synchronizationManager = synchronizationManager;
    }

    public static Collection enumerateCacheServices() {
        LinkedList<Object> services = new LinkedList<Object>();
        Cluster cluster = CacheFactory.getCluster();
        if (cluster.isRunning()) {
            Enumeration serviceNames = cluster.getServiceNames();
            while (serviceNames.hasMoreElements()) {
                String serviceName = (String)serviceNames.nextElement();
                Service service = cluster.getService(serviceName);
                if (!(service instanceof CacheService)) continue;
                services.add(service);
            }
        } else {
            services.add(CacheFactory.getLocalCacheService(null));
        }
        return services;
    }

    public void init() {
        if (this.isRunning()) {
            this.getInvocationService();
            this.registerClusterMemberEventLogger();
        }
    }

    public void shutdown() {
        this.stopCluster();
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down Coherence services");
        }
        CacheFactory.shutdown();
    }

    private boolean isRunning() {
        return this.getCluster().isRunning();
    }

    protected void registerClusterMemberEventLogger() {
        Cluster cluster = this.getCluster();
        cluster.getService("Cluster").addMemberListener((MemberListener)MEMBER_EVENT_LOGGER);
    }

    public void publishObject(String key, Serializable object) {
        NamedCache cache = this.getPublishedCache();
        cache.put((Object)key, (Object)object);
    }

    public Serializable getPublishedObject(String key) {
        NamedCache cache = this.getPublishedCache();
        if (cache != null) {
            return (SharedConfigurationMap)cache.get((Object)key);
        }
        return null;
    }

    private NamedCache getPublishedCache() {
        return CacheFactory.getCache((String)PUBLISHED_CACHE_NAME);
    }

    private Cluster getCluster() {
        Cluster cluster = CacheFactory.getCluster();
        cluster.setContextClassLoader(this.applicationClassLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded cluster [ " + cluster.getClass().getName() + " ] with class loader [ " + cluster.getContextClassLoader() + " ]"));
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        ApplicationConfig applicationConfig = this.applicationConfig;
        synchronized (applicationConfig) {
            Object isClustered = this.applicationConfig.getProperty((Object)"confluence.cluster");
            return "true".equals(isClustered);
        }
    }

    public int getPermittedClusterNodes() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        if (license == null) {
            return 0;
        }
        return license.getPermittedClusteredNodes();
    }

    public ClusterInformation getClusterInformation() {
        if (this.clusterInformation == null) {
            return new EmptyClusterInformation();
        }
        return this.clusterInformation;
    }

    public Lock getLock(String key) {
        return this.getClusteredLock(key);
    }

    public ClusteredLock getClusteredLock(String key) {
        return new TangosolClusteredLock(CacheFactory.getCache((String)LOCK_CACHE_NAME), key);
    }

    public FifoBuffer getFifoBuffer(String name) {
        return new TangosolClusteredFifoBuffer(CacheFactory.getCache((String)("confluence.fifo.buffer." + name)));
    }

    public void publishEvent(final ConfluenceEvent event) {
        this.synchronizationManager.runOnSuccessfulCommit(new Runnable(){

            public void run() {
                if (TangosolClusterManager.this.isRunning()) {
                    TangosolClusterManager.this.getInvocationService().execute((Invocable)new EventInvocable(event), null, null);
                }
            }

            public String toString() {
                return "Sending remote event: " + event;
            }
        });
    }

    public InvocationService getInvocationService() {
        return CacheFactory.getInvocationService((String)"confluence.invocation");
    }

    public ClusterNodeInformation getThisNodeInformation() {
        return new TangosolClusterNodeInformation(this.getCluster().getLocalMember());
    }

    public void stopCluster() {
        if (!this.isRunning()) {
            return;
        }
        log.info((Object)"Stopping cluster service");
        this.getCluster().shutdown();
        this.clusterInformation = null;
    }

    public void startCluster() {
        if (this.isRunning()) {
            return;
        }
        log.info((Object)"Bringing up cluster service");
        this.getCluster().start();
        CacheFactory.ensureCluster();
        this.init();
    }

    public InetAddress resolveName(String name) {
        return this.clusterNameResolver.resolveName(name);
    }

    public void configure(ClusterConfig config) {
        XmlElement clusterXmlConfig = this.mergeConfig(config);
        Cluster cluster = this.getCluster();
        cluster.configure(clusterXmlConfig);
        this.clusterInformation = new TangosolClusterInformation(cluster, clusterXmlConfig);
    }

    public boolean isConfigured() {
        return this.clusterInformation != null;
    }

    public void reconfigure(ClusterConfig config) {
        this.stopCluster();
        this.configure(config);
        this.startCluster();
    }

    private XmlElement mergeConfig(ClusterConfig config) {
        XmlElement merged = CacheFactory.getClusterConfig();
        XmlElement classpathConfig = this.getClasspathConfig();
        XmlElement homeConfig = this.getHomeConfig();
        XmlElement confluenceConfig = this.getXmlConfig(config);
        XmlHelper.replaceSystemProperties((XmlElement)merged, (String)"system-property");
        if (classpathConfig != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Classpath configuration: \n" + classpathConfig));
            }
            XmlHelper.replaceSystemProperties((XmlElement)classpathConfig, (String)"system-property");
            XmlHelper.overrideElement((XmlElement)merged, (XmlElement)classpathConfig);
        }
        if (homeConfig != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Confluence home configuration: \n" + homeConfig));
            }
            XmlHelper.replaceSystemProperties((XmlElement)homeConfig, (String)"system-property");
            XmlHelper.overrideElement((XmlElement)merged, (XmlElement)homeConfig);
        }
        XmlHelper.overrideElement((XmlElement)merged, (XmlElement)confluenceConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merged configuration: \n" + merged));
        }
        return merged;
    }

    private XmlElement getXmlConfig(ClusterConfig config) {
        String clusterConfigStr = "<cluster-config>\n    <member-identity>        <cluster-name>{0}</cluster-name>\n    </member-identity>    <multicast-listener>\n        <time-to-live>{1}</time-to-live>\n        <address>{2}</address>\n    </multicast-listener>\n</cluster-config>\n";
        clusterConfigStr = MessageFormat.format(clusterConfigStr, config.getClusterName(), new Integer(config.getTimeToLive()), config.getAddress().getHostAddress());
        XmlDocument clusterConfigXml = XmlHelper.loadXml((String)clusterConfigStr);
        if (config.getUnicastAddress() != null) {
            String unicastConfigStr = "<cluster-config>\n<unicast-listener>\n<address>" + config.getUnicastAddress().getHostAddress() + "</address>\n" + "</unicast-listener>\n" + "</cluster-config>";
            XmlDocument unicastDefXml = XmlHelper.loadXml((String)unicastConfigStr);
            XmlHelper.overrideElement((XmlElement)clusterConfigXml, (XmlElement)unicastDefXml);
        }
        return clusterConfigXml;
    }

    private XmlElement getDefaultConfig() {
        return this.getClasspathResource(COHERENCE_DEFAULTS);
    }

    private XmlElement getHomeConfig() {
        return this.getHomeResource(OVERRIDE_FILE_NAME);
    }

    private XmlElement getClasspathConfig() {
        return this.getClasspathResource(OVERRIDE_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlElement getClasspathResource(String fileName) {
        InputStream is = null;
        XmlDocument defaults = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)fileName, TangosolClusterManager.class);
            if (is == null) {
                XmlElement xmlElement = null;
                return xmlElement;
            }
            defaults = XmlHelper.loadXml((InputStream)is);
        }
        finally {
            IOUtils.close(is);
        }
        return this.getClusterConfigElement(defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlElement getHomeResource(String fileName) {
        XmlDocument defaults = null;
        FileInputStream is = null;
        File file = new File(this.applicationConfig.getApplicationHome(), fileName);
        try {
            is = new FileInputStream(file);
            defaults = XmlHelper.loadXml((InputStream)is);
        }
        catch (FileNotFoundException e) {
            XmlElement xmlElement;
            try {
                xmlElement = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
            IOUtils.close(is);
            return xmlElement;
        }
        IOUtils.close(is);
        return this.getClusterConfigElement(defaults);
    }

    private XmlElement getClusterConfigElement(XmlDocument defaults) {
        return defaults.getRoot().getElement("cluster-config");
    }

    private static class MemberEventLogger
    implements MemberListener {
        private MemberEventLogger() {
        }

        public void memberJoined(MemberEvent memberEvent) {
            if (log.isInfoEnabled()) {
                log.info((Object)("New member joined cluster: " + memberEvent.getMember()));
            }
        }

        public void memberLeaving(MemberEvent memberEvent) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Member leaving cluster: " + memberEvent.getMember()));
            }
        }

        public void memberLeft(MemberEvent memberEvent) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Member has left cluster: " + memberEvent.getMember()));
            }
        }
    }

    public static abstract class RetryOperation {
        public abstract Object op();

        public abstract void reInit();

        public Object doOp() {
            while (true) {
                try {
                    return this.op();
                }
                catch (IllegalStateException ise) {
                    log.warn((Object)"Exception performing an operation which must succeed. Reinitialising and retrying.", (Throwable)ise);
                    this.reInit();
                    continue;
                }
                break;
            }
        }
    }
}

