/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.page.DeletePageCommand;
import com.atlassian.confluence.content.service.page.IdPageLocator;
import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.MovePageCommandImpl;
import com.atlassian.confluence.content.service.page.MovePageToTopOfSpaceCommand;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.page.RevertPageCommand;
import com.atlassian.confluence.content.service.page.RevertPageOrderCommand;
import com.atlassian.confluence.content.service.page.SetPageOrderCommand;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPageService
implements PageService {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;

    public DefaultPageService(PageManager pageManager, PermissionManager permissionManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, PageLocator targetPageLocator, String position) {
        return new MovePageCommandImpl(this.pageManager, this.permissionManager, sourcePageLocator, targetPageLocator, position);
    }

    @Override
    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator) {
        return new MovePageToTopOfSpaceCommand(this.pageManager, this.permissionManager, sourcePageLocator, targetSpaceLocator);
    }

    @Override
    public ServiceCommand newSetPageOrderCommand(PageLocator parentPageLocator, List<Long> childPageIds) {
        return new SetPageOrderCommand(this.pageManager, this.permissionManager, parentPageLocator, childPageIds);
    }

    @Override
    public ServiceCommand newRevertPageOrderCommand(PageLocator parentPageLocator) {
        return new RevertPageOrderCommand(this.pageManager, this.permissionManager, parentPageLocator);
    }

    @Override
    public ServiceCommand newDeletePageCommand(PageLocator pageLocator) {
        return new DeletePageCommand(this.pageManager, this.permissionManager, pageLocator);
    }

    @Override
    public PageLocator getIdPageLocator(long pageId) {
        return new IdPageLocator(this.pageManager, pageId);
    }

    @Override
    public ServiceCommand newRevertPageCommand(PageLocator pageToRevert, int version, String revertComment, boolean revertTitle) {
        return new RevertPageCommand(this.pageManager, this.permissionManager, pageToRevert, revertComment, version, revertTitle);
    }
}

