/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.page.TrashPageCommand;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;

public class TrashPageCommandImpl
extends AbstractServiceCommand
implements TrashPageCommand {
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final long pageId;

    public TrashPageCommandImpl(PermissionManager permissionManager, PageManager pageManager, long pageId) {
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.pageId = pageId;
    }

    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.getPage() == null) {
            validator.addFieldValidationError("pageId", "service.error.trash.page.not.found", this.pageId);
        }
    }

    protected boolean isAuthorizedInternal() {
        return this.getPage() == null || this.permissionManager.hasPermission(this.getCurrentUser(), Permission.REMOVE, this.getPage());
    }

    protected void executeInternal() {
    }

    private Page getPage() {
        return this.pageManager.getPage(this.pageId);
    }
}

