/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InheritedContentPermissionManager;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.persistence.dao.ContentPermissionSetDao;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class CachingInheritedContentPermissionManager
implements InheritedContentPermissionManager,
EventListener {
    private static final Logger log = Logger.getLogger(CachingInheritedContentPermissionManager.class);
    private InheritedContentPermissionManager defaultInheritedContentPermissionManager;
    private PageManager pageManager;
    private CacheFactory cacheFactory;
    private ContentPermissionSetDao contentPermissionSetDao;

    public List getInheritedContentPermissionSets(ContentEntityObject contentEntityObject) {
        Long cacheKey = new Long(contentEntityObject.getId());
        try {
            Object cachedResult = this.getCache().get((Object)cacheKey);
            if (cachedResult != null) {
                return this.rehydrate((List)cachedResult);
            }
            List rawResult = this.defaultInheritedContentPermissionManager.getInheritedContentPermissionSets(contentEntityObject);
            this.dehydrateAndCache(cacheKey, rawResult);
            return rawResult;
        }
        catch (InfrastructureException e) {
            log.error((Object)"Error fetching result from cache", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public void handleEvent(Event event) {
        ContentPermissionEvent contentPermEvent = (ContentPermissionEvent)event;
        ContentEntityObject content = contentPermEvent.getContent();
        if (content == null) {
            log.warn((Object)("ContentPermissionEvent fired by " + event.getSource() + " has null content"));
            return;
        }
        ContentPermission contentPermission = contentPermEvent.getContentPermission();
        if (contentPermission == null || "View".equals(contentPermission.getType())) {
            this.removeFromCache(content);
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ContentPermissionEvent.class};
    }

    private void dehydrateAndCache(Long cacheKey, List rawResult) {
        ArrayList<Long> dehydratedObjects = new ArrayList<Long>(rawResult.size());
        for (ContentPermissionSet contentPermissionSet : rawResult) {
            dehydratedObjects.add(new Long(contentPermissionSet.getId()));
        }
        this.getCache().put((Object)cacheKey, new ArrayList(dehydratedObjects));
    }

    private List rehydrate(List list) {
        ArrayList<ContentPermissionSet> hydratedObjects = new ArrayList<ContentPermissionSet>(list.size());
        for (Long id : list) {
            ContentPermissionSet permSet = this.contentPermissionSetDao.getById(id);
            if (permSet == null) {
                log.error((Object)("Unable to retrieve cached content property ID from database " + id));
                continue;
            }
            hydratedObjects.add(permSet);
        }
        return hydratedObjects;
    }

    private void removeFromCache(ContentEntityObject content) {
        if (content == null) {
            return;
        }
        try {
            this.getCache().remove((Object)new Long(content.getId()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        for (Long descendentId : this.pageManager.getDescendentIds((Page)content)) {
            try {
                this.getCache().remove((Object)new Long(descendentId));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_KEY_CONTENT_LEVEL_PERMISSIONS_CACHE);
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public ContentPermissionSetDao getContentPermissionSetDao() {
        return this.contentPermissionSetDao;
    }

    public void setContentPermissionSetDao(ContentPermissionSetDao contentPermissionSetDao) {
        this.contentPermissionSetDao = contentPermissionSetDao;
    }

    public void setDefaultInheritedContentPermissionManager(InheritedContentPermissionManager defaultInheritedContentPermissionManager) {
        this.defaultInheritedContentPermissionManager = defaultInheritedContentPermissionManager;
    }
}

