/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.actions.CreateBlogPostAction;
import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.pages.actions.EditBlogPostAction;
import com.atlassian.confluence.pages.actions.EditPageAction;
import com.atlassian.confluence.spaces.actions.CreateSpaceAction;
import com.atlassian.confluence.spaces.actions.EditSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.DefaultWorkflowInterceptor;

public class ConfluenceWorkflowInterceptor
extends DefaultWorkflowInterceptor {
    private UserChecker userChecker;

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        if (actionInvocation.getAction() instanceof ConfluenceActionSupport && this.shouldCheckForLicense(actionInvocation)) {
            if (GeneralUtil.isLicenseExpired()) {
                return "licenseexpired";
            }
            if (this.getUserChecker() != null && this.getUserChecker().hasTooManyUsers()) {
                return "licenseusersexceeded";
            }
        }
        return super.intercept(actionInvocation);
    }

    private UserChecker getUserChecker() {
        if (this.userChecker == null && ContainerManager.isContainerSetup()) {
            this.userChecker = (UserChecker)ContainerManager.getComponent((String)"userChecker");
        }
        return this.userChecker;
    }

    private boolean shouldCheckForLicense(ActionInvocation actionInvocation) {
        return BootstrapUtils.getBootstrapManager().isSetupComplete() && actionInvocation.getAction() instanceof CreateSpaceAction || actionInvocation.getAction() instanceof EditSpaceAction || actionInvocation.getAction() instanceof CreatePageAction || actionInvocation.getAction() instanceof EditPageAction || actionInvocation.getAction() instanceof CreateBlogPostAction || actionInvocation.getAction() instanceof EditBlogPostAction;
    }
}

