/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.core.persistence.confluence.StaleObjectStateException;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.persistence.dao.PageDao;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.event.EventManager;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class DefaultContentEntityManager
implements ContentEntityManager {
    private static Category log = Category.getInstance(DefaultContentEntityManager.class);
    protected ContentEntityObjectDao contentEntityObjectDao;
    protected LinkManager linkManager;
    protected ConfluenceIndexer indexer;
    protected EventManager eventManager;
    private LabelManager labelManager;

    public void setContentEntityObjectDao(ContentEntityObjectDao contentEntityObjectDao) {
        this.contentEntityObjectDao = contentEntityObjectDao;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void saveContentEntity(ContentEntityObject obj, SaveContext saveContext) {
        boolean isNewContentObject = true;
        if (obj != null && obj.getId() != 0L) {
            boolean bl = isNewContentObject = this.contentEntityObjectDao.getById(obj.getId()) == null;
        }
        if (saveContext != null && !saveContext.doUpdateLastModifier()) {
            this.contentEntityObjectDao.saveRaw(obj);
        } else {
            this.contentEntityObjectDao.save(obj);
        }
        if (isNewContentObject) {
            this.publishCreateEvent(obj);
        } else {
            this.publishUpdateEvent(obj, null, saveContext);
        }
        this.linkManager.updateOutgoingLinks(obj);
    }

    public void saveContentEntity(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        this.contentEntityObjectDao.save(obj, origObj);
        this.publishUpdateEvent(obj, origObj, saveContext);
        this.linkManager.updateOutgoingLinks(obj);
    }

    public void removeContentEntity(ContentEntityObject obj) {
        if (obj.getOriginalVersion() == null) {
            this.publishRemoveEvent(obj);
            this.labelManager.removeAllLabels(obj);
        }
        this.contentEntityObjectDao.remove(obj);
    }

    public void refreshContentEntity(ContentEntityObject obj) {
        this.contentEntityObjectDao.refresh(obj);
    }

    public ContentEntityObject getById(long id) {
        return this.contentEntityObjectDao.getById(id);
    }

    public void revertContentEntityBackToVersion(ContentEntityObject obj, int version) {
        this.revertContentEntityBackToVersion(obj, version, null, false);
    }

    public void revertContentEntityBackToVersion(ContentEntityObject obj, int version, String revertComment, boolean revertTitle) {
        ContentEntityObject unmodifiedContent;
        if (!obj.isLatestVersion()) {
            throw new StaleObjectStateException("Page revert back can not be done for the non-latest version!");
        }
        if (obj.getVersion() == version) {
            throw new StaleObjectStateException("Can't revert a page back to itself");
        }
        try {
            unmodifiedContent = (ContentEntityObject)obj.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Can't clone page?!", (Throwable)e);
            throw new InfrastructureException("Can't clone content entity object: " + obj, (Throwable)e);
        }
        ContentEntityObject prevVerContent = this.getOtherVersion(obj, version);
        if (prevVerContent == null) {
            throw new InfrastructureException("The specified version not found to revert back!");
        }
        obj.setContent(prevVerContent.getContent());
        if (revertTitle) {
            obj.setTitle(prevVerContent.getTitle());
        }
        obj.setVersionComment(revertComment);
        this.saveContentEntity(obj, unmodifiedContent, null);
    }

    public Iterator getRecentlyAddedEntities(String spaceKey, int maxResults) {
        return this.contentEntityObjectDao.getRecentlyAddedEntities(spaceKey, maxResults);
    }

    public Iterator getRecentlyModifiedEntities(String spaceKey, int maxResults) {
        return this.contentEntityObjectDao.getRecentlyModifiedEntities(spaceKey, maxResults);
    }

    public Iterator getRecentlyModifiedEntities(int maxResults) {
        return this.contentEntityObjectDao.getRecentlyModifiedEntities(maxResults);
    }

    public Iterator getAllCurrentEntities() {
        return this.contentEntityObjectDao.getAllCurrentEntities();
    }

    public Iterator getRecentlyModifiedEntitiesForUser(String username) {
        return this.contentEntityObjectDao.getRecentlyModifiedEntitiesForUser(username);
    }

    public Iterator getRecentlyModifiedEntitiesByType(ListQuery query, int firstResult) {
        return this.contentEntityObjectDao.getRecentlyModifiedEntitiesByType(query, firstResult);
    }

    public List getEntitiesModifiedSince(Date date) {
        return this.getRecentlyModifiedForChangeDigest(date);
    }

    public List getRecentlyModifiedForChangeDigest(Date fromDate) {
        return this.contentEntityObjectDao.getEntitiesModifiedSince(fromDate);
    }

    public List getLockedBySpace(String spaceKey) {
        return this.contentEntityObjectDao.getLockedContentBySpace(spaceKey);
    }

    public void updateOutgoingLinksInContent(SpaceContentEntityObject contentBeingRefactored, String newSpaceKey) {
        this.updateOutgoingLinksInContent(contentBeingRefactored, newSpaceKey, true);
    }

    public void updateOutgoingLinksInContent(SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, boolean saveNewVersion) {
        try {
            String updatedContent = this.linkManager.getSelfContentWithRenamedLinks(contentBeingRefactored, newSpaceKey);
            contentBeingRefactored.setContent(updatedContent);
            if (saveNewVersion) {
                ContentEntityObject originalContent = (ContentEntityObject)contentBeingRefactored.clone();
                originalContent.convertToHistoricalVersion();
                this.saveContentEntity(contentBeingRefactored, originalContent, null);
            } else {
                this.linkManager.updateOutgoingLinks(contentBeingRefactored);
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Can not clone the object!", (Throwable)e);
        }
    }

    public void updateContentLinkingTo(SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, String newTitle) {
        this.updateContentLinkingTo(contentBeingRefactored, newSpaceKey, newTitle, true);
    }

    public void updateContentLinkingTo(SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, String newTitle, boolean saveNewVersion) {
        DefaultSaveContext saveContext = new DefaultSaveContext();
        saveContext.setMinorEdit(true);
        for (ContentEntityObject referringContent : this.linkManager.getReferringContent(contentBeingRefactored)) {
            if (referringContent.equals(contentBeingRefactored)) continue;
            this.updateSingleContentLinkinTo(referringContent, contentBeingRefactored, newSpaceKey, newTitle, saveContext, saveNewVersion);
        }
    }

    public void updateSingleContentLinkinTo(ContentEntityObject referringContent, SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, String newTitle) {
        this.updateSingleContentLinkinTo(referringContent, contentBeingRefactored, newSpaceKey, newTitle, null);
    }

    public void updateSingleContentLinkinTo(ContentEntityObject referringContent, SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, String newTitle, SaveContext saveContext) {
        this.updateSingleContentLinkinTo(referringContent, contentBeingRefactored, newSpaceKey, newTitle, saveContext, true);
    }

    public void updateSingleContentLinkinTo(ContentEntityObject referringContent, SpaceContentEntityObject contentBeingRefactored, String newSpaceKey, String newTitle, SaveContext saveContext, boolean saveNewVersion) {
        try {
            ContentEntityObject originalVersion = (ContentEntityObject)referringContent.clone();
            String updatedContent = this.linkManager.getContentWithRenamedLinks(referringContent, contentBeingRefactored, newSpaceKey, newTitle);
            referringContent.setContent(updatedContent);
            if (saveNewVersion) {
                this.saveContentEntity(referringContent, originalVersion, saveContext);
            } else {
                this.linkManager.updateOutgoingLinks(referringContent);
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Can not clone the object!", (Throwable)e);
        }
    }

    public ContentEntityObject getPreviousVersion(ContentEntityObject ceo) {
        ContentEntityObject latestVersion = (ContentEntityObject)ceo.getLatestVersion();
        return this.contentEntityObjectDao.getFirstVersionBefore(latestVersion.getId(), ceo.getVersion());
    }

    public ContentEntityObject getNextVersion(ContentEntityObject ceo) {
        ContentEntityObject latestVersion = (ContentEntityObject)ceo.getLatestVersion();
        return this.contentEntityObjectDao.getFirstVersionAfter(latestVersion.getId(), ceo.getVersion());
    }

    public ContentEntityObject getOtherVersion(ContentEntityObject ceo, int version) {
        if (ceo.getVersion() == version) {
            return ceo;
        }
        ContentEntityObject latestVersion = (ContentEntityObject)ceo.getLatestVersion();
        if (latestVersion.getVersion() == version) {
            return latestVersion;
        }
        return this.contentEntityObjectDao.getVersion(latestVersion.getId(), version);
    }

    public List getVersionHistorySummaries(ContentEntityObject ceo) {
        return this.contentEntityObjectDao.getVersionHistorySummary(((ContentEntityObject)ceo.getLatestVersion()).getId());
    }

    protected PageDao getPageDao() {
        return (PageDao)this.contentEntityObjectDao;
    }

    protected void publishCreateEvent(ContentEntityObject obj) {
        log.warn((Object)"Tried to publish a create event from generic content manager", (Throwable)new UnsupportedOperationException());
    }

    protected void publishUpdateEvent(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        log.warn((Object)"Tried to publish an update event from generic content manager", (Throwable)new UnsupportedOperationException());
    }

    protected void publishRemoveEvent(ContentEntityObject obj) {
        log.warn((Object)"Tried to publish a remove event from generic content manager", (Throwable)new UnsupportedOperationException());
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    protected EventManager getEventManager() {
        return this.eventManager;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }
}

