/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.InheritedContentPermissionManager;
import com.atlassian.confluence.core.persistence.ContentPermissionDao;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.persistence.dao.ContentPermissionSetDao;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultContentPermissionManager
implements ContentPermissionManager {
    private static final Logger log = Logger.getLogger(DefaultContentPermissionManager.class);
    protected PageManager pageManager;
    private ContentPermissionSetDao contentPermissionSetDao;
    protected ContentPermissionDao contentPermissionDao;
    private ConfluenceIndexer indexer;
    private EventManager eventManager;
    private InheritedContentPermissionManager inheritedContentPermissionManager;

    private void reindexContent(ContentEntityObject content) {
        if (content == null) {
            return;
        }
        this.indexer.reIndex(content);
        if (content instanceof Page) {
            for (Page descendent : this.pageManager.getDescendents((Page)content)) {
                this.indexer.reIndex(descendent);
                this.indexPageDependencies(descendent);
            }
            this.indexPageDependencies(content);
        }
    }

    private void indexPageDependencies(ContentEntityObject content) {
        for (Attachment attachment : content.getAttachments()) {
            this.indexer.reIndex((Searchable)attachment);
        }
        for (Comment comment : ((AbstractPage)content).getComments()) {
            this.indexer.reIndex(comment);
        }
    }

    public List getInheritedContentPermissions(ContentEntityObject contentEntityObject) {
        ArrayList inheritedPermissions = new ArrayList();
        List inheritedContentPermissionSets = this.getInheritedContentPermissionSets(contentEntityObject);
        for (ContentPermissionSet contentPermissionSet : inheritedContentPermissionSets) {
            Iterator cpsIterator = contentPermissionSet.iterator();
            while (cpsIterator.hasNext()) {
                inheritedPermissions.add(cpsIterator.next());
            }
        }
        return inheritedPermissions;
    }

    public List getInheritedContentUserPermissions(ContentEntityObject contentEntityObject) {
        ArrayList<ContentPermission> inheritedUserPermissions = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : this.getInheritedContentPermissionSets(contentEntityObject)) {
            Iterator cpsIterator = contentPermissionSet.iterator();
            while (cpsIterator.hasNext()) {
                ContentPermission contentPermission = (ContentPermission)cpsIterator.next();
                if (!contentPermission.isUserPermission()) continue;
                inheritedUserPermissions.add(contentPermission);
            }
        }
        return inheritedUserPermissions;
    }

    public List getInheritedContentPermissionSets(ContentEntityObject contentEntityObject) {
        return this.inheritedContentPermissionManager.getInheritedContentPermissionSets(this.getLatestVersion(contentEntityObject));
    }

    private ContentEntityObject getLatestVersion(ContentEntityObject contentEntityObject) {
        return (ContentEntityObject)contentEntityObject.getLatestVersion();
    }

    public List getContentPermissionSets(ContentEntityObject ceo, String type) {
        ContentPermissionSet explicitContentPermissionSet;
        ArrayList<ContentPermissionSet> result = new ArrayList<ContentPermissionSet>();
        if ("View".equals(type)) {
            result.addAll(this.getInheritedContentPermissionSets(ceo));
        }
        if ((explicitContentPermissionSet = this.getLatestVersion(ceo).getContentPermissionSet(type)) != null) {
            result.add(explicitContentPermissionSet);
        }
        return result;
    }

    public boolean hasContentLevelPermission(User user, String permissionType, ContentEntityObject contentEntityObject) {
        boolean isPermitted;
        ContentEntityObject latestVersion = this.getLatestVersion(contentEntityObject);
        ContentPermissionSet explicitContentPermissionSet = latestVersion.getContentPermissionSet(permissionType);
        boolean bl = isPermitted = explicitContentPermissionSet == null || explicitContentPermissionSet.isPermitted(user);
        if (!isPermitted) {
            return false;
        }
        List inheritedContentPermissionSets = Collections.EMPTY_LIST;
        if ("View".equals(permissionType)) {
            inheritedContentPermissionSets = this.getInheritedContentPermissionSets(latestVersion);
        }
        for (ContentPermissionSet contentPermissionSet : inheritedContentPermissionSets) {
            if (contentPermissionSet.isPermitted(user)) continue;
            return false;
        }
        return true;
    }

    public void removeContentPermission(ContentPermission contentPermission) {
        String type;
        ContentEntityObject content = contentPermission.getOwningSet().getOwningContent();
        ContentPermissionSet set = content.getContentPermissionSet(type = contentPermission.getType());
        if (set != null) {
            set.removeContentPermission(contentPermission);
            if (set.isEmpty()) {
                content.removeContentPermissionSet(set);
                this.contentPermissionSetDao.remove(set);
            }
        }
        this.contentPermissionDao.remove(contentPermission);
        this.reindexContent(content);
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, content, contentPermission));
    }

    public void removeAllGroupPermissions(String groupName) {
        List permissions = this.contentPermissionDao.getGroupPermissions(groupName);
        this.removeContentPermissions(permissions);
    }

    public void removeAllUserPermissions(String userName) {
        List permissions = this.contentPermissionDao.getUserPermissions(userName);
        this.removeContentPermissions(permissions);
    }

    private void removeContentPermissions(List permissions) {
        for (ContentPermission permission : permissions) {
            this.removeContentPermission(permission);
        }
    }

    public void addContentPermission(ContentPermission permission, ContentEntityObject content) {
        if (!content.isLatestVersion()) {
            throw new IllegalArgumentException("ContentEntityObject must correspond to the latest version of a content. Permissions can only be added to the latest version of a content.");
        }
        content.addPermission(permission);
        this.contentPermissionDao.save(permission);
        this.reindexContent(content);
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, content, permission));
    }

    public void setContentPermissions(Collection requiredPermissions, ContentEntityObject content, String type) {
        ContentPermissionSet cps = content.getContentPermissionSet(type);
        for (ContentPermission contentPermission : requiredPermissions) {
            if (!type.equals(contentPermission.getType())) {
                log.warn((Object)("Attempt was made to add contentPermission: " + contentPermission + " as having type: " + type + " instead of type " + contentPermission.getType()));
                continue;
            }
            if (cps != null && cps.contains(contentPermission)) continue;
            this.addContentPermission(contentPermission, content);
        }
        if (cps != null) {
            Collection toRemove = cps.getAllExcept(requiredPermissions);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeContentPermission((ContentPermission)it.next());
            }
        }
    }

    public List getPermittedChildren(Page page, User user) {
        ArrayList<Page> permittedChildren = new ArrayList<Page>();
        for (Page child : page.getChildren()) {
            if (!this.hasContentLevelPermission(user, "View", child)) continue;
            permittedChildren.add(child);
        }
        Collections.sort(permittedChildren, Page.pageComparator);
        return permittedChildren;
    }

    public List getInheritedViewContentPermissions(Page page) {
        return this.getInheritedContentPermissions(page);
    }

    public Set getViewContentPermissions(Page page) {
        ContentEntityObject latestVersion = this.getLatestVersion(page);
        HashSet<ContentPermission> viewContentPermissions = new HashSet<ContentPermission>(this.getInheritedContentPermissions(latestVersion));
        ContentPermission viewPermission = latestVersion.getContentPermission("View");
        if (viewPermission != null) {
            viewContentPermissions.add(viewPermission);
        }
        return viewContentPermissions;
    }

    public void setContentPermissionDao(ContentPermissionDao contentPermissionDao) {
        this.contentPermissionDao = contentPermissionDao;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContentPermissionSetDao(ContentPermissionSetDao contentPermissionSetDao) {
        this.contentPermissionSetDao = contentPermissionSetDao;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setInheritedContentPermissionManager(InheritedContentPermissionManager inheritedContentPermissionManager) {
        this.inheritedContentPermissionManager = inheritedContentPermissionManager;
    }
}

