/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.core.ConfluencePropertySetManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.core.exception.InfrastructureException;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.Serializable;
import org.apache.log4j.Category;

public class DefaultContentPropertyManager
implements ContentPropertyManager {
    private static final Category log = Category.getInstance(DefaultContentPropertyManager.class);
    private CacheManager cacheManager;
    private ConfluencePropertySetManager propertySetManager;
    private static final NegativeCacheHit NEGATIVE_CACHE_HIT = new NegativeCacheHit();

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private Cache getCache() {
        return this.cacheManager.getCache(DefaultContentPropertyManager.class.getName());
    }

    public void setPropertySetManager(ConfluencePropertySetManager propertySetManager) {
        this.propertySetManager = propertySetManager;
    }

    public String getStringProperty(ContentEntityObject entity, String key) {
        return (String)((Object)this.cacheGet(entity, key, String.class, new Getter(){

            public Serializable get(PropertySet propertySet, String key) {
                return propertySet.getString(key);
            }
        }));
    }

    public void setStringProperty(ContentEntityObject entity, String key, String value) {
        if (value != null && value.length() > 255) {
            value = value.substring(0, 255);
        }
        this.cacheSet(entity, key, (Serializable)((Object)value));
        this.getPropertySet(entity).setString(key, value);
    }

    public String getTextProperty(ContentEntityObject entity, String key) {
        return (String)((Object)this.cacheGet(entity, key, String.class, new Getter(){

            public Serializable get(PropertySet propertySet, String key) {
                return propertySet.getText(key);
            }
        }));
    }

    public void setTextProperty(ContentEntityObject entity, String key, String value) {
        this.cacheSet(entity, key, (Serializable)((Object)value));
        this.getPropertySet(entity).setText(key, value);
    }

    public void removeProperties(ContentEntityObject entity) {
        PropertySet propertySet = this.getPropertySet(entity);
        for (String key : propertySet.getKeys()) {
            propertySet.remove(key);
            this.cacheRemove(entity, key);
        }
    }

    private PropertySet getPropertySet(ContentEntityObject object) {
        return this.propertySetManager.getPropertySet(object);
    }

    private void cacheRemove(ContentEntityObject entity, String key) {
        CacheKey cacheKey = new CacheKey(entity.getId(), key);
        this.getCache().remove((Object)cacheKey);
    }

    private void cacheSet(ContentEntityObject entity, String key, Serializable value) {
        CacheKey cacheKey = new CacheKey(entity.getId(), key);
        this.getCache().put((Object)cacheKey, (Object)value);
    }

    private Serializable cacheGet(ContentEntityObject entity, String key, Class expectedClass, Getter getter) {
        Serializable value;
        block8: {
            value = null;
            try {
                CacheKey cacheKey = new CacheKey(entity.getId(), key);
                value = (Serializable)this.getCache().get((Object)cacheKey);
                if (value == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cache miss for " + cacheKey));
                    }
                    value = this.retrieveAndCacheProperty(entity, key, getter, value);
                }
                if (value instanceof NegativeCacheHit) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Negative cache hit for " + cacheKey));
                    }
                    value = null;
                }
                if (value == null || value.getClass().isAssignableFrom(expectedClass)) break block8;
                log.warn((Object)("Expected " + cacheKey + " to return " + expectedClass.getName() + " but got " + value + " (" + value.getClass().getName() + ")"));
                try {
                    this.getCache().remove((Object)cacheKey);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                value = null;
            }
            catch (InfrastructureException e) {
                log.error((Object)("Flushing all caches due to cache exception looking up " + key + " for " + entity), (Throwable)e);
                this.cacheManager.flushCaches();
            }
        }
        return value;
    }

    private Serializable retrieveAndCacheProperty(ContentEntityObject entity, String key, Getter getter, Serializable value) {
        PropertySet p = this.getPropertySet(entity);
        if (p.exists(key)) {
            value = getter.get(p, key);
            this.cacheSet(entity, key, value);
        } else {
            this.cacheSet(entity, key, NEGATIVE_CACHE_HIT);
        }
        return value;
    }

    private static interface Getter {
        public Serializable get(PropertySet var1, String var2);
    }

    private static class NegativeCacheHit
    implements Serializable {
        private NegativeCacheHit() {
        }
    }

    private static class CacheKey
    implements Serializable {
        private final String propertyKey;
        private final long contentId;

        public CacheKey(long contentId, String propertyKey) {
            this.propertyKey = propertyKey;
            this.contentId = contentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.contentId != cacheKey.contentId) {
                return false;
            }
            return this.propertyKey.equals(cacheKey.propertyKey);
        }

        public int hashCode() {
            int result = this.propertyKey.hashCode();
            result = 29 * result + (int)(this.contentId ^ this.contentId >>> 32);
            return result;
        }

        public String toString() {
            return "id: " + this.contentId + " key: " + this.propertyKey;
        }
    }
}

