/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.util.HashMap;
import java.util.Map;

public class DefaultFormatSettingsManager
implements FormatSettingsManager {
    private static final BandanaContext BANDANA_CONTEXT = new ConfluenceBandanaContext();
    private static final String BANDANA_KEY = DefaultFormatSettingsManager.class.getName();
    private static final String DATE_FORMAT = "dateFormat";
    private static final String TIME_FORMAT = "timeFormat";
    private static final String DAY_FORMAT = "dayFormat";
    private static final String DATE_TIME_FORMAT = "dateTimeFormat";
    private static final String LONG_NUMBER_FORMAT = "longNumberFormat";
    private static final String DECIMAL_NUMBER_FORMAT = "decimalNumberFormat";
    private BandanaManager bandanaManager;
    public static final String DEFAULT_DATE_PATTERN = "MMM dd, yyyy";
    public static final String DEFAULT_DATE_TIME_PATTERN = "MMM dd, yyyy HH:mm";
    public static final String DEFAULT_DAY_PATTERN = "MMM dd";
    public static final String BLOG_DATE_PATTERN = "dd MMM '@' h:mm a";
    public static final String DEFAULT_TIME_PATTERN = "h:mm a";
    public static final String DEFAULT_LONG_NUMBER_PATTERN = "###############";
    public static final String DEFAULT_DECIMAL_NUMBER_PATTERN = "###############.##########";

    private Map retrieveSettings() {
        Object settings = this.bandanaManager.getValue(BANDANA_CONTEXT, BANDANA_KEY);
        if (settings == null || !(settings instanceof Map)) {
            return new HashMap();
        }
        return (Map)settings;
    }

    private String getSetting(String settingName, String defaultValue) {
        Map settings = this.retrieveSettings();
        String value = (String)settings.get(settingName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void saveSettings(Map settings) {
        this.bandanaManager.setValue(BANDANA_CONTEXT, BANDANA_KEY, (Object)settings);
    }

    private void setSetting(String settingName, String value) {
        Map settings = this.retrieveSettings();
        settings.put(settingName, value);
        this.saveSettings(settings);
    }

    public String getDateFormat() {
        return this.getSetting(DATE_FORMAT, DEFAULT_DATE_PATTERN);
    }

    public void setDateFormat(String pattern) {
        this.setSetting(DATE_FORMAT, pattern);
    }

    public String getTimeFormat() {
        return this.getSetting(TIME_FORMAT, DEFAULT_TIME_PATTERN);
    }

    public void setTimeFormat(String pattern) {
        this.setSetting(TIME_FORMAT, pattern);
    }

    public String getDayFormat() {
        return this.getSetting(DAY_FORMAT, DEFAULT_DAY_PATTERN);
    }

    public void setDayFormat(String pattern) {
        this.setSetting(DAY_FORMAT, pattern);
    }

    public String getDateTimeFormat() {
        return this.getSetting(DATE_TIME_FORMAT, DEFAULT_DATE_TIME_PATTERN);
    }

    public void setDateTimeFormat(String pattern) {
        this.setSetting(DATE_TIME_FORMAT, pattern);
    }

    public String getLongNumberFormat() {
        return this.getSetting(LONG_NUMBER_FORMAT, DEFAULT_LONG_NUMBER_PATTERN);
    }

    public void setLongNumberFormat(String pattern) {
        this.setSetting(LONG_NUMBER_FORMAT, pattern);
    }

    public String getDecimalNumberFormat() {
        return this.getSetting(DECIMAL_NUMBER_FORMAT, DEFAULT_DECIMAL_NUMBER_PATTERN);
    }

    public void setDecimalNumberFormat(String pattern) {
        this.setSetting(DECIMAL_NUMBER_FORMAT, pattern);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

