/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.ActivityAjaxResponse;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.HeartbeatAjax;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultHeartbeatAjax
implements HeartbeatAjax {
    private static final Logger log = Logger.getLogger(DefaultHeartbeatAjax.class);
    private HeartbeatManager heartbeatManager;
    private DraftManager draftManager;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private FormatSettingsManager formatSettingsManager;
    private DateFormatter dateFormatter;

    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this.heartbeatManager = heartbeatManager;
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatManager.getHeartbeatInterval();
    }

    public void stopActivity(String key, String type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("stopping for key [" + key + type + "], user [" + AuthenticatedUserThreadLocal.getUser() + "]"));
        }
        this.heartbeatManager.stopActivity(key + type, AuthenticatedUserThreadLocal.getUser());
    }

    public ActivityAjaxResponse[] startActivity(String key, String type) {
        try {
            User currentUser = AuthenticatedUserThreadLocal.getUser();
            I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(currentUser));
            String activityKey = key + type;
            if (currentUser != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("starting for key [" + activityKey + "], user [" + currentUser + "]"));
                }
                this.heartbeatManager.startActivity(activityKey, currentUser);
            }
            List users = this.heartbeatManager.getUsersForActivity(activityKey);
            ArrayList<ActivityAjaxResponse> activityResponses = new ArrayList<ActivityAjaxResponse>();
            for (User user : users) {
                if (currentUser != null && user.equals(currentUser)) continue;
                Draft d = this.draftManager.findDraft(key, user.getName(), type);
                activityResponses.add(new ActivityAjaxResponse(user.getFullName(), this.getLastEdit(d, i18NBean), user.getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("found " + activityResponses.size() + " responses: " + activityResponses));
            }
            return activityResponses.toArray(new ActivityAjaxResponse[activityResponses.size()]);
        }
        catch (RuntimeException t) {
            log.error((Object)("Error during startActivity:" + t.getMessage()), (Throwable)t);
            throw t;
        }
    }

    private String getLastEdit(Draft d, I18NBean i18NBean) {
        if (d == null) {
            return null;
        }
        FriendlyDateFormatter friendlyDateFormatter = new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), this.getDateFormatter());
        Message message = friendlyDateFormatter.getFormatMessage(d.getLastModificationDate());
        String lastEditFriendlyDate = i18NBean.getText(message.getKey(), message.getArguments());
        return i18NBean.getText("heartbeat.last.edit", new String[]{lastEditFriendlyDate});
    }

    private DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
            User user = AuthenticatedUserThreadLocal.getUser();
            this.dateFormatter = userAccessor.getConfluenceUserPreferences(user).getDateFormatter(this.formatSettingsManager);
        }
        return this.dateFormatter;
    }
}

