/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.concurrent.LockFactory;
import com.atlassian.confluence.concurrent.LockOperationWithoutResult;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultHeartbeatManager
implements HeartbeatManager {
    public static final long TIMEOUT_MS = 30000L;
    private static final String ACTIVITY_CACHE_NAME = "com.atlassian.confluence.core.DefaultHeartbeatManager.activities";
    private Cache activities;
    private CacheFactory cacheFactory;
    private LockFactory lockFactory;

    public long getHeartbeatInterval() {
        return 30000L;
    }

    public List getUsersForActivity(Object key) {
        ArrayList userList = new ArrayList();
        new GetUsersForActivityOperation(this.getActivityLock(key), key, userList).run();
        return userList;
    }

    private Lock getActivityLock(Object key) {
        return this.lockFactory.getLock("com.atlassian.confluence.core.DefaultHeartbeatManager.activities." + key.toString());
    }

    public void startActivity(Object key, User user) {
        if (user == null) {
            return;
        }
        new StartActivityOperation(this.getActivityLock(key), key, user).run();
    }

    public void stopActivity(Object key, User user) {
        if (user == null) {
            return;
        }
        new StopActivityOperation(this.getActivityLock(key), key, user).run();
    }

    public void init() {
        this.activities = this.cacheFactory.getCache(ACTIVITY_CACHE_NAME);
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    private class GetUsersForActivityOperation
    extends LockOperationWithoutResult {
        private final Object key;
        private final List l;

        public GetUsersForActivityOperation(Lock lock, Object key, List l) {
            super(lock);
            this.key = key;
            this.l = l;
        }

        protected void withLockNoResult() {
            Set s = (Set)DefaultHeartbeatManager.this.activities.get(this.key);
            if (s == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            Iterator iterator = s.iterator();
            while (iterator.hasNext()) {
                Activity activity = (Activity)iterator.next();
                if (currentTime - activity.getDate().getTime() > 60000L) {
                    iterator.remove();
                    continue;
                }
                this.l.add(activity.getUser());
            }
            DefaultHeartbeatManager.this.activities.put(this.key, (Object)s);
        }
    }

    private class StopActivityOperation
    extends LockOperationWithoutResult {
        private final Object key;
        private final User user;

        public StopActivityOperation(Lock lock, Object key, User user) {
            super(lock);
            this.key = key;
            this.user = user;
        }

        protected void withLockNoResult() {
            Set s = (Set)DefaultHeartbeatManager.this.activities.get(this.key);
            if (s != null) {
                s.remove(new Activity(this.key, this.user));
                DefaultHeartbeatManager.this.activities.put(this.key, (Object)s);
            }
        }
    }

    private class StartActivityOperation
    extends LockOperationWithoutResult {
        private final Object key;
        private final User user;

        public StartActivityOperation(Lock lock, Object key, User user) {
            super(lock);
            this.key = key;
            this.user = user;
        }

        protected void withLockNoResult() {
            HashSet<Activity> s = (HashSet<Activity>)DefaultHeartbeatManager.this.activities.get(this.key);
            if (s == null) {
                s = new HashSet<Activity>();
            }
            Activity a = new Activity(this.key, this.user);
            s.remove(a);
            s.add(a);
            DefaultHeartbeatManager.this.activities.put(this.key, s);
        }
    }

    private static class Activity
    implements Serializable {
        private Date date = new Date();
        private transient User user;
        private String userName;
        private Object key;

        public Date getDate() {
            return this.date;
        }

        public User getUser() {
            return this.user;
        }

        public Object getKey() {
            return this.key;
        }

        public Activity(Object key, User user) {
            this.user = user;
            this.userName = user.getName();
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Activity activity = (Activity)o;
            if (!this.key.equals(activity.key)) {
                return false;
            }
            return this.user.equals(activity.user);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 29 * result + this.key.hashCode();
            return result;
        }

        private Object readResolve() throws ObjectStreamException {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
            this.user = userAccessor.getUser(this.userName);
            return this;
        }
    }
}

