/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.Searcher;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.SmartListManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.search.CompositeSearch;
import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.lucene.filter.ContentPermissionsFilter;
import com.atlassian.confluence.search.scope.ExcludeMailAttachmentsScope;
import com.atlassian.confluence.search.scope.ExcludeProfileAttachmentsScope;
import com.atlassian.confluence.search.scope.LabelScope;
import com.atlassian.confluence.search.scope.ModifiedInLastDaysScope;
import com.atlassian.confluence.search.scope.PermittedSpacesScope;
import com.atlassian.confluence.search.scope.SpaceScope;
import com.atlassian.confluence.search.scope.TypeScope;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class LuceneSmartListManager
implements SmartListManager {
    public static final Category log = Category.getInstance(LuceneSmartListManager.class);
    private SpaceManager spaceManager;
    private LuceneConnection luceneConnection;
    private UserAccessor userAccessor;
    private AnyTypeObjectDao anyTypeObjectDao;
    private Searcher searcher;
    private ConfluenceIndexManager indexManager;
    private LabelManager labelManager;

    public String getStatusMessageKey() {
        if (this.indexManager.isReIndexing()) {
            return "reindex.in.progress";
        }
        return null;
    }

    public List getListQueryResults(ListQuery query, boolean loadObjects) {
        if (!this.luceneConnection.isIndexCreated()) {
            return Collections.EMPTY_LIST;
        }
        BooleanQuery luceneQuery = this.buildLuceneQuery(query);
        Sort sort = new Sort(query.getSortBy(), true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n\nquery = " + query.getDescription()));
            log.debug((Object)("luceneQuery = " + luceneQuery));
        }
        return this.performLuceneQuery((Query)luceneQuery, sort, query.getMaxResults(), loadObjects);
    }

    private BooleanQuery buildLuceneQuery(ListQuery query) {
        ConfluenceSearchScope search = this.buildSearchScope(query);
        BooleanQuery luceneQuery = new BooleanQuery();
        search.restrictQuery(query.getUser(), luceneQuery);
        this.secureLuceneQuery(luceneQuery, query.getUser());
        return luceneQuery;
    }

    private BooleanQuery secureLuceneQuery(BooleanQuery luceneQuery, User user) {
        new PermittedSpacesScope(this.spaceManager).restrictQuery(user, luceneQuery);
        return luceneQuery;
    }

    private ConfluenceSearchScope buildSearchScope(ListQuery query) {
        CompositeSearch search = new CompositeSearch();
        search.addSearch(SpaceScope.fromSpaceList(query.getSpaceList(), query.getSpaceScopes(), this.labelManager));
        search.addSearch(new TypeScope(query.getTypeList()));
        search.addSearch(new ExcludeProfileAttachmentsScope());
        if (!query.getTypeList().contains("mail")) {
            search.addSearch(new ExcludeMailAttachmentsScope());
        }
        search.addSearch(new LabelScope(query.getLabelList(), query.getLabelOccur()));
        int daysAgo = (int)query.getTimeSpan();
        int n = daysAgo = daysAgo == 0 ? 7 : daysAgo;
        if (daysAgo != -1) {
            search.addSearch(new ModifiedInLastDaysScope(daysAgo));
        }
        return search;
    }

    private List performLuceneQuery(final Query luceneQuery, final Sort sort, final int maxResults, final boolean loadObjects) {
        UtilTimerStack.push((String)"LuceneSmartListManager.performLuceneQuery");
        try {
            User user = AuthenticatedUserThreadLocal.getUser();
            Pager groups = user != null ? this.userAccessor.getGroups(user) : null;
            final ContentPermissionsFilter contentPermissionsFilter = new ContentPermissionsFilter(user, groups);
            final List[] results = new List[]{null};
            this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

                public boolean perform(IndexSearcher searcher) throws IOException {
                    Hits hits = searcher.search(luceneQuery, contentPermissionsFilter, sort);
                    results[0] = LuceneSmartListManager.this.extractResults(hits, loadObjects, maxResults);
                    return true;
                }
            });
            UtilTimerStack.pop((String)"LuceneSmartListManager.performLuceneQuery");
            return results[0];
        }
        catch (Throwable e) {
            if (e.getMessage().endsWith("no terms in field modified - cannot determine sort type")) {
                log.info((Object)"Error encountered in lucene search - most likely empty index", e);
            } else {
                log.error((Object)("Error encountered in lucene search: " + e.getMessage()), e);
            }
            UtilTimerStack.pop((String)"LuceneSmartListManager.performLuceneQuery");
            return Collections.EMPTY_LIST;
        }
    }

    private List extractResults(Hits hits, boolean loadObjects, int maxResults) throws IOException {
        UtilTimerStack.push((String)"LuceneSmartListManager.extractResults");
        log.debug((Object)("Extracting Results. Hits.length = " + hits.length() + ", max returned = " + maxResults));
        log.debug((Object)("loadObjects = " + loadObjects));
        int max = Math.min(hits.length(), maxResults);
        ArrayList<Object> results = new ArrayList<Object>(max);
        for (int i = 0; i < hits.length() && results.size() < max; ++i) {
            Document doc = hits.doc(i);
            if (loadObjects) {
                String handle = doc.get("handle");
                try {
                    Object o = this.anyTypeObjectDao.findByHandle((Handle)new HibernateHandle(handle));
                    if (o == null) {
                        log.debug((Object)("Handle " + handle + " is in index, but not in database"));
                        continue;
                    }
                    results.add(o);
                }
                catch (ParseException e) {
                    log.error((Object)("Invalid object handle: " + handle + " - " + e.getMessage()), (Throwable)e);
                }
                continue;
            }
            results.add(new SearchResultWithExcerpt(LuceneUtils.buildMapFromDocument((Document)doc)));
        }
        UtilTimerStack.pop((String)"LuceneSmartListManager.extractResults");
        return results;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void setIndexManager(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

