/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.util.ClasspathUtils;
import com.atlassian.confluence.util.classpath.ClasspathClasses;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Category;

public class TimeZone {
    private static Category log = Category.getInstance(TimeZone.class);
    private static final Map timeZonesByID = TimeZone.loadTimeZones();
    private java.util.TimeZone wrappedTimeZone;

    public static TimeZone getInstance(String timeZoneID) {
        if (!timeZonesByID.containsKey(timeZoneID)) {
            return TimeZone.getDefault();
        }
        return (TimeZone)timeZonesByID.get(timeZoneID);
    }

    private TimeZone(String timeZoneID) {
        this.wrappedTimeZone = timeZoneID == null ? java.util.TimeZone.getDefault() : java.util.TimeZone.getTimeZone(timeZoneID);
    }

    public String getID() {
        return this.wrappedTimeZone.getID();
    }

    public String getMessageKey() {
        return "time.zone." + this.getID().replaceAll("[^A-Za-z]", ".");
    }

    public String toString() {
        return this.getMessageKey();
    }

    public boolean equals(Object o) {
        if (!o.getClass().equals(TimeZone.class)) {
            return false;
        }
        return ((TimeZone)o).getID().equals(this.getID());
    }

    public String getDisplayOffset() {
        int offset = this.getRawOffset();
        String sign = offset < 0 ? "-" : "+";
        offset = Math.abs(offset);
        int millis = offset % 1000;
        offset = (offset - millis) / 1000;
        int seconds = offset % 60;
        offset = (offset - seconds) / 60;
        int minutes = offset % 60;
        int hours = offset = (offset - minutes) / 60;
        return MessageFormat.format("{0}{1,number,00}{2,number,00}", sign, new Integer(hours), new Integer(minutes));
    }

    private int getRawOffset() {
        return this.wrappedTimeZone.getRawOffset();
    }

    public static TimeZone getDefault() {
        String defaultTimezoneId = java.util.TimeZone.getDefault().getID();
        if (!timeZonesByID.containsKey(defaultTimezoneId)) {
            log.debug((Object)("Adding Server's default timezone: " + defaultTimezoneId));
            timeZonesByID.put(defaultTimezoneId, new TimeZone(defaultTimezoneId));
        }
        return TimeZone.getInstance(defaultTimezoneId);
    }

    public static List getSortedTimeZones() {
        TreeSet timeZones = new TreeSet(new TimeZoneComparator());
        timeZones.addAll(timeZonesByID.values());
        ArrayList<TimeZone> result = new ArrayList<TimeZone>();
        for (TimeZone timeZone : timeZones) {
            result.add(timeZone);
        }
        return result;
    }

    private static Map loadTimeZones() {
        Properties timeZoneProperties = new Properties();
        try {
            InputStream asStream = ClassLoaderUtils.getResourceAsStream((String)"com/atlassian/confluence/core/timezones.properties", TimeZone.class);
            if (asStream == null) {
                ClasspathClasses clazzes = ClasspathUtils.getFilesInClasspathJars();
                throw new RuntimeException("Cannot find timeezone.properties. The classpath is " + clazzes.getJarUrlsByClass().toString());
            }
            timeZoneProperties.load(asStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load time zones from properties file.", e);
        }
        String timeZoneList = timeZoneProperties.getProperty("time.zone.list");
        if (timeZoneList == null || timeZoneList.trim().equals("")) {
            throw new RuntimeException("time.zone.list property missing from time zones properties file");
        }
        String[] timeZoneIDs = timeZoneList.split("[, ]+");
        HashMap<String, TimeZone> result = new HashMap<String, TimeZone>();
        for (int i = 0; i < timeZoneIDs.length; ++i) {
            String timeZoneID = timeZoneIDs[i];
            result.put(timeZoneID, new TimeZone(timeZoneID));
        }
        return result;
    }

    public java.util.TimeZone getWrappedTimeZone() {
        return this.wrappedTimeZone;
    }

    private static class TimeZoneComparator
    implements Comparator {
        private TimeZoneComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof TimeZone)) {
                return 0;
            }
            if (!(o2 instanceof TimeZone)) {
                return 0;
            }
            TimeZone tz1 = (TimeZone)o1;
            TimeZone tz2 = (TimeZone)o2;
            if (tz1.getRawOffset() < tz2.getRawOffset()) {
                return -1;
            }
            if (tz1.getRawOffset() > tz2.getRawOffset()) {
                return 1;
            }
            return tz1.getID().compareToIgnoreCase(tz2.getID());
        }
    }
}

