/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.editor.Editor;
import com.atlassian.confluence.plugin.editor.EditorManager;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.commons.lang.StringUtils;

public class CombinedStylesheetAction
extends ConfluenceActionSupport {
    public static final String RESULT_SETUP = "setup";
    private String spaceKey;
    private boolean forWysiwyg;
    private EditorManager editorManager;
    private ThemeManager themeManager;
    private Theme theme;

    public boolean isPermitted() {
        return true;
    }

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("text/css");
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            return RESULT_SETUP;
        }
        this.theme = this.getActiveTheme(this.spaceKey);
        return "success";
    }

    private Theme getActiveTheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.themeManager.getSpaceTheme(spaceKey);
        }
        return this.themeManager.getGlobalTheme();
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setForWysiwyg(boolean forWysiwyg) {
        this.forWysiwyg = forWysiwyg;
    }

    public boolean isForWysiwyg() {
        return this.forWysiwyg;
    }

    public Editor getEditor() {
        return this.editorManager.getCurrentEditor();
    }

    public void setEditorManager(EditorManager editorManager) {
        this.editorManager = editorManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public Theme getTheme() {
        return this.theme;
    }
}

