/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.actions.LastModifiedAware;
import com.atlassian.confluence.plugin.editor.Editor;
import com.atlassian.confluence.plugin.editor.EditorManager;
import com.atlassian.confluence.themes.ColorSchemeBean;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.themes.DefaultColourScheme;
import com.atlassian.confluence.themes.DefaultTheme;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.LastModifiedHandler;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StylesheetAction
extends ConfluenceActionSupport
implements LastModifiedAware {
    public static final Logger log = Logger.getLogger(StylesheetAction.class);
    public static final String RESULT_SETUP = "setup";
    private static final String RESULT_PLUGIN = "pluginresource";
    private ColorSchemeBean colorScheme;
    private ColourSchemeManager colourSchemeManager;
    private String spaceKey;
    private String pluginCompleteKey;
    private String stylesheetName;
    private String stylesheetLocation;
    private boolean forWysiwyg;
    private EditorManager editorManager;
    private ThemeManager themeManager;
    private PluginAccessor pluginAccessor;
    private Theme theme;
    private static Map lastModifiedHandlers = new HashMap();

    public StylesheetAction() {
    }

    public StylesheetAction(ColourScheme colourScheme) {
        this.colorScheme = new ColorSchemeBean(colourScheme);
    }

    public boolean isPermitted() {
        return true;
    }

    public String executeForAdmin() throws Exception {
        ServletActionContext.getResponse().setContentType("text/css");
        this.colorScheme = new ColorSchemeBean(DefaultColourScheme.getInstance());
        this.theme = DefaultTheme.getInstance();
        return "success";
    }

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("text/css");
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            return RESULT_SETUP;
        }
        if (this.forWysiwyg) {
            this.colorScheme = new ColorSchemeBean(DefaultColourScheme.getInstance());
            this.theme = DefaultTheme.getInstance();
        } else {
            this.colorScheme = new ColorSchemeBean(this.getActiveColourScheme(this.spaceKey));
            this.theme = this.getActiveTheme(this.spaceKey);
        }
        if (StringUtils.isNotEmpty((String)this.pluginCompleteKey) && this.isModuleSeparateToTheme(this.pluginCompleteKey, this.theme)) {
            ResourceLocation resource = this.getStylesheetResource(this.pluginCompleteKey, this.stylesheetName);
            if (resource != null) {
                this.stylesheetLocation = this.prependSlashIfMissing(resource.getLocation());
                return RESULT_PLUGIN;
            }
            log.warn((Object)("Couldn't find matching stylesheet resource for pluginCompleteKey: [" + this.pluginCompleteKey + "], stylesheetName: [" + this.stylesheetName + "]"));
        }
        return "success";
    }

    private ColourScheme getActiveColourScheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.colourSchemeManager.getSpaceColourScheme(spaceKey);
        }
        return this.colourSchemeManager.getGlobalColourScheme();
    }

    private Theme getActiveTheme(String spaceKey) {
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            return this.themeManager.getSpaceTheme(spaceKey);
        }
        return this.themeManager.getGlobalTheme();
    }

    private boolean isModuleSeparateToTheme(String moduleCompleteKey, Theme theme) {
        if (StringUtils.isEmpty((String)moduleCompleteKey)) {
            return false;
        }
        if (theme == null || theme.getPluginKey() == null) {
            return true;
        }
        return !moduleCompleteKey.startsWith(theme.getPluginKey());
    }

    private ResourceLocation getStylesheetResource(String moduleCompleteKey, String stylesheetName) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (module == null) {
            return null;
        }
        return module.getResourceLocation("stylesheet", stylesheetName);
    }

    private String prependSlashIfMissing(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("/")) {
            return text;
        }
        return "/" + text;
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setPluginCompleteKey(String pluginCompleteKey) {
        this.pluginCompleteKey = pluginCompleteKey;
    }

    public void setStylesheetName(String stylesheetName) {
        this.stylesheetName = stylesheetName;
    }

    public ColorSchemeBean getColourScheme() {
        return this.colorScheme;
    }

    public String getTopBarColor() {
        return this.colorScheme.getTopBarColor();
    }

    public String getBreadcrumbsTextColour() {
        return this.colorScheme.getBreadcrumbsTextColor();
    }

    public String getSpaceNameColor() {
        return this.colorScheme.getSpaceNameColor();
    }

    public String getHeadingTextColor() {
        return this.colorScheme.getHeadingTextColor();
    }

    public String getLinkColor() {
        return this.colorScheme.getLinkColor();
    }

    public String getBorderColor() {
        return this.colorScheme.getBorderColor();
    }

    public String getNavBackgroundColor() {
        return this.colorScheme.getNavBackgroundColor();
    }

    public String getNavTextColor() {
        return this.colorScheme.getNavTextColor();
    }

    public String getNavSelectedBackgroundColor() {
        return this.colorScheme.getNavSelectedBackgroundColor();
    }

    public String getNavSelectedTextColor() {
        return this.colorScheme.getNavSelectedTextColor();
    }

    public String getTopBarColour() {
        return this.colorScheme.getTopBarColor();
    }

    public String getSpaceNameColour() {
        return this.colorScheme.getTopBarColor();
    }

    public String getHeadingTextColour() {
        return this.colorScheme.getHeadingTextColor();
    }

    public String getLinkColour() {
        return this.colorScheme.getLinkColor();
    }

    public String getBorderColour() {
        return this.colorScheme.getBorderColor();
    }

    public String getNavBackgroundColour() {
        return this.colorScheme.getNavBackgroundColor();
    }

    public String getNavTextColour() {
        return this.colorScheme.getNavTextColor();
    }

    public String getNavSelectedBackgroundColour() {
        return this.colorScheme.getNavSelectedBackgroundColor();
    }

    public String getNavSelectedTextColour() {
        return this.colorScheme.getNavSelectedTextColor();
    }

    public void setColourSchemeManager(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    public boolean isForWysiwyg() {
        return this.forWysiwyg;
    }

    public void setForWysiwyg(boolean forWysiwyg) {
        this.forWysiwyg = forWysiwyg;
    }

    public Editor getEditor() {
        return this.editorManager.getCurrentEditor();
    }

    public void setEditorManager(EditorManager editorManager) {
        this.editorManager = editorManager;
    }

    public LastModifiedHandler getLastModifiedHandler() {
        return StylesheetAction.getLastModifiedHandlerForSpace(this.getSpaceKey());
    }

    public static synchronized LastModifiedHandler getLastModifiedHandlerForSpace(String spaceKey) {
        String key = "com.atlassian.confluence.core.actions.StylesheetAction." + (spaceKey == null ? "global" : spaceKey);
        LastModifiedHandler handler = (LastModifiedHandler)lastModifiedHandlers.get(key);
        if (handler == null) {
            handler = new LastModifiedHandler();
            lastModifiedHandlers.put(key, handler);
        }
        return handler;
    }

    public boolean isUserAgentIE() {
        if (ServletActionContext.getRequest() == null) {
            return false;
        }
        String userAgent = ServletActionContext.getRequest().getHeader("User-Agent");
        return TextUtils.stringSet((String)userAgent) && userAgent.indexOf("MSIE") != -1;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

