/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.datetime;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.util.i18n.Message;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class FriendlyDateFormatter {
    private static final String FORMATTED = "date.friendly.formatted";
    private static final String NOW = "date.friendly.now";
    private static final String A_MOMENT_AGO = "date.friendly.a.moment.ago";
    private static final String LESS_THAN_A_MINUTE_AGO = "less.than.one.min";
    private static final String ONE_MINUTE_AGO = "one.min.ago";
    private static final String X_MINUTES_AGO = "x.mins.ago";
    private static final String ABOUT_ONE_HOUR_AGO = "date.friendly.about.one.hour.ago";
    private static final String ABOUT_X_HOURS_AGO = "date.friendly.about.x.hours.ago";
    private static final String YESTERDAY = "date.friendly.yesterday";
    private final DateTime now;
    private final DateFormatter dateFormatter;

    public FriendlyDateFormatter(DateFormatter dateFormatter) {
        this(new Date(), dateFormatter);
    }

    public FriendlyDateFormatter(Date now, DateFormatter dateFormatter) {
        this.now = new DateTime((Object)now);
        this.dateFormatter = dateFormatter;
    }

    public Message getFormatMessage(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        if (dateTime.isAfter((ReadableInstant)this.now)) {
            return Message.getInstance(FORMATTED, new Object[]{this.dateFormatter.formatDateTime(date)});
        }
        if (dateTime.isEqual((ReadableInstant)this.now)) {
            return Message.getInstance(NOW);
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.seconds((int)4)))) {
            return Message.getInstance(A_MOMENT_AGO);
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.minutes((int)1)))) {
            return Message.getInstance(LESS_THAN_A_MINUTE_AGO);
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.minutes((int)2)))) {
            return Message.getInstance(ONE_MINUTE_AGO);
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.minutes((int)50)))) {
            return Message.getInstance(X_MINUTES_AGO, new Object[]{new Integer(this.getMinutesBetween(dateTime, this.now))});
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.minutes((int)90)))) {
            return Message.getInstance(ABOUT_ONE_HOUR_AGO);
        }
        if (this.isYesterday(dateTime) && dateTime.isBefore((ReadableInstant)this.now.minus((ReadablePeriod)Period.hours((int)5)))) {
            return Message.getInstance(YESTERDAY, new Object[]{this.dateFormatter.formatTime(date)});
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.days((int)1)))) {
            return Message.getInstance(ABOUT_X_HOURS_AGO, new Object[]{new Integer(this.getRoundedHoursBetween(dateTime, this.now))});
        }
        if (dateTime.isAfter((ReadableInstant)this.now.minus((ReadablePeriod)Period.months((int)6)))) {
            return Message.getInstance(FORMATTED, new Object[]{this.dateFormatter.formatDay(date)});
        }
        return Message.getInstance(FORMATTED, new Object[]{this.dateFormatter.format(date)});
    }

    private boolean isYesterday(DateTime date) {
        DateTimeZone timeZone = DateTimeZone.forTimeZone((TimeZone)this.dateFormatter.getTimeZone().getWrappedTimeZone());
        DateTime end = this.now.withZone(timeZone).withTime(0, 0, 0, 0);
        DateTime start = end.minusDays(1);
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        return interval.contains((ReadableInstant)date);
    }

    private int getRoundedHoursBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        int hours = period.getHours();
        if (period.getMinutes() >= 30) {
            ++hours;
        }
        return hours;
    }

    private int getMinutesBetween(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end).getMinutes();
    }
}

