/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.VersionedHibernateObjectDao;
import com.atlassian.core.exception.InfrastructureException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class ConfluenceHibernateObjectDao
extends VersionedHibernateObjectDao {
    protected List findByQuery(final String query, int maxResultCount) {
        try {
            Query hibernateQuery = (Query)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query resultQuery = session.createQuery(query);
                    SessionFactoryUtils.applyTransactionTimeout((Query)resultQuery, (SessionFactory)ConfluenceHibernateObjectDao.this.getSessionFactory());
                    return resultQuery;
                }
            });
            hibernateQuery.setMaxResults(maxResultCount);
            return hibernateQuery.list();
        }
        catch (Exception e) {
            log.error((Object)"findByQuery error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }
}

