/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.confluence.core.VersionHistory;
import com.atlassian.confluence.core.persistence.VersionHistoryDao;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.hibernate.HibernateObjectDao;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import org.apache.log4j.Category;

public class HibernateVersionHistoryDao
extends HibernateObjectDao
implements VersionHistoryDao {
    private static final Category log = Category.getInstance(HibernateVersionHistoryDao.class);

    public Class getPersistentClass() {
        return VersionHistory.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestBuildNumber() {
        int n;
        ResultSet rs;
        Statement st;
        block5: {
            Session session = this.getSession(true);
            st = null;
            rs = null;
            Connection conn = session.connection();
            st = conn.createStatement();
            rs = st.executeQuery("select max(BUILDNUMBER) from CONFVERSION");
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            JDBCUtils.close((Statement)st);
            JDBCUtils.close((ResultSet)rs);
            return n2;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            int n3;
            try {
                log.warn((Object)("Unable to determine build number from database. If you are upgrading from a Confluence version prior to 2.3, this is expected: " + e.getMessage()));
                n3 = 0;
            }
            catch (Throwable throwable) {
                JDBCUtils.close(st);
                JDBCUtils.close(rs);
                throw throwable;
            }
            JDBCUtils.close((Statement)st);
            JDBCUtils.close((ResultSet)rs);
            return n3;
        }
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((ResultSet)rs);
        return n;
    }

    public VersionHistory getVersionHistory(int buildNumber) {
        List results = this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.confversion_findByBuildNumber", "buildNumber", (Object)new Integer(buildNumber));
        if (results.size() > 0) {
            return (VersionHistory)((Object)results.iterator().next());
        }
        return null;
    }

    public boolean tagBuild(int buildNumber, String tag) {
        boolean buildTagged = false;
        Session session = this.getSession();
        VersionHistory buildNumberRow = this.getVersionHistory(buildNumber);
        if (buildNumberRow == null) {
            try {
                this.addBuildToHistory(buildNumber);
                buildNumberRow = this.getVersionHistory(buildNumber);
            }
            catch (Throwable e) {
                throw new RuntimeException("Attempted to add a duplicate row. This may be caused by two nodes trying to create this row at the same time. This is a symptom of a communication problem between one or more nodes in your cluster.", e);
            }
        }
        try {
            session.lock((Object)buildNumberRow, LockMode.UPGRADE);
            if (tag.equals(buildNumberRow.getVersionTag())) {
                buildTagged = false;
            } else {
                buildNumberRow.setVersionTag(tag);
                this.getHibernateTemplate().update((Object)buildNumberRow);
                buildTagged = true;
            }
            session.lock((Object)buildNumberRow, LockMode.NONE);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Error acquiring lock on CONFVERSION table.", e);
        }
        return buildTagged;
    }

    public void addBuildToHistory(int buildNumber) {
        VersionHistory versionHistory = this.getVersionHistory(buildNumber);
        if (versionHistory == null) {
            this.getHibernateTemplate().save((Object)new VersionHistory(buildNumber, new Date()));
        } else {
            versionHistory.setInstallationDate(new Date());
            this.getHibernateTemplate().update((Object)versionHistory);
        }
    }
}

