/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dashboard.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.SmartListManager;
import com.atlassian.confluence.search.SpacePickerHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.util.PairType;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.opensymphony.webwork.ServletActionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConfigureRssFeedAction
extends ConfluenceActionSupport {
    private static final String CREATE_RSSFEED_URL = "/createrssfeed.action?";
    private ContentEntityManager contentEntityManager;
    private SpaceManager spaceManager;
    private String title;
    private List spaces;
    private List types;
    private boolean created;
    private boolean modified;
    private int maxResults = 10;
    private int timeSpan = 5;
    private String rssType = "atom";
    private String sort = "modified";
    private boolean publicFeed;
    private boolean showDiff;
    private boolean showContent;
    private List contentList;
    private String rssLink;
    private static final String ALL_SPACES = "";
    private SpacePickerHelper spacePickerHelper;

    public void validate() {
        super.validate();
        if (this.spaces == null || this.spaces.size() == 0) {
            this.addFieldError("spaces", this.getText("no.spaces.selected"));
        }
        if (this.types == null || this.types.size() == 0) {
            this.addFieldError("types", this.getText("no.content.type.selected"));
        }
    }

    public String doDefault() throws Exception {
        this.spacePickerHelper = new SpacePickerHelper(this.spaceManager, this.labelManager);
        this.setTitle(this.getText("rss.feed", new Object[]{this.settingsManager.getGlobalSettings().getSiteTitle()}));
        this.setContentList(this.extractKeysFromList(this.getPrimaryContentEntityTypes()));
        return super.doDefault();
    }

    public String execute() throws Exception {
        this.spacePickerHelper = new SpacePickerHelper(this.spaceManager, this.labelManager);
        this.setRssLink(this.createRssLink());
        return "success";
    }

    private String createRssLink() {
        StringBuffer rssString = new StringBuffer();
        rssString.append(this.settingsManager.getGlobalSettings().getBaseUrl());
        rssString.append(CREATE_RSSFEED_URL);
        rssString.append(ServletActionContext.getRequest().getQueryString());
        if (!this.showContent) {
            rssString.append("&showContent=false");
        }
        if (!this.showDiff) {
            rssString.append("&showDiff=false");
        }
        if (!this.publicFeed) {
            String authType = "&" + SecurityConfigFactory.getInstance().getAuthType() + "=" + "basic";
            rssString.append(authType);
        }
        return rssString.toString();
    }

    public ContentEntityManager getContentEntityManager() {
        return this.contentEntityManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public List getPrimaryContentEntityTypes() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"page"), (Serializable)((Object)this.getText("list.element.page"))));
        result.add(new PairType((Serializable)((Object)"blogpost"), (Serializable)((Object)this.getText("list.element.blogpost"))));
        result.add(new PairType((Serializable)((Object)"mail"), (Serializable)((Object)this.getText("list.element.mail"))));
        return result;
    }

    public List getSubContentEntityTypes() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"comment"), (Serializable)((Object)this.getText("list.element.comment"))));
        if (!this.isWebdavEnabled()) {
            result.add(new PairType((Serializable)((Object)"attachment"), (Serializable)((Object)this.getText("list.element.attachment"))));
        }
        return result;
    }

    public List getContentStatusList() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"created"), (Serializable)((Object)this.getText("list.element.created"))));
        result.add(new PairType((Serializable)((Object)"modified"), (Serializable)((Object)this.getText("list.element.modified"))));
        return result;
    }

    public List getRssTypes() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"rss1"), (Serializable)((Object)this.getText("rss.type.rss1"))));
        result.add(new PairType((Serializable)((Object)"rss2"), (Serializable)((Object)this.getText("rss.type.rss2"))));
        result.add(new PairType((Serializable)((Object)"atom"), (Serializable)((Object)this.getText("rss.type.atom"))));
        return result;
    }

    public List getRssSorts() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"created"), (Serializable)((Object)this.getText("list.element.created"))));
        result.add(new PairType((Serializable)((Object)"modified"), (Serializable)((Object)this.getText("list.element.modified"))));
        return result;
    }

    public List getAccessTypes() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)String.valueOf(false)), (Serializable)((Object)this.getText("access.private"))));
        result.add(new PairType((Serializable)((Object)String.valueOf(true)), (Serializable)((Object)this.getText("access.public"))));
        return result;
    }

    public String getNiceRssType() {
        for (int i = 0; i < this.getRssTypes().size(); ++i) {
            PairType pairType = (PairType)this.getRssTypes().get(i);
            if (!pairType.getKey().equals(this.getRssType())) continue;
            return (String)((Object)pairType.getValue());
        }
        return this.getText("rss.type.rss1");
    }

    private List extractKeysFromList(List list) {
        ArrayList<Serializable> keyList = new ArrayList<Serializable>();
        for (int i = 0; i < list.size(); ++i) {
            PairType pairType = (PairType)list.get(i);
            keyList.add(pairType.getKey());
        }
        return keyList;
    }

    public String getSpacesAsNiceList(List spaceList) {
        String spaceListString = spaceList == null ? this.getText("description.feed.nospaces") : (spaceList.contains(ALL_SPACES) ? this.getText("description.feed.allspaces") : StringUtils.join(spaceList.iterator(), (String)", "));
        return spaceListString;
    }

    public List getAvailableSpaces() {
        return this.spacePickerHelper.getAvailableSpaces(this.getRemoteUser());
    }

    public List getAvailableGlobalSpaces() {
        return this.spacePickerHelper.getAvailableGlobalSpaces(this.getRemoteUser());
    }

    public List getAggregateOptions() {
        return this.spacePickerHelper.getAggregateOptions(this);
    }

    public List getFavouriteSpaces() {
        return this.spacePickerHelper.getFavouriteSpaces(this.getRemoteUser());
    }

    public String getNiceListString(List list) {
        if (list == null) {
            return ALL_SPACES;
        }
        ArrayList<String> textList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String element = (String)list.get(i);
            textList.add(this.getText("list.element." + element));
        }
        return StringUtils.join(textList.iterator(), (String)", ");
    }

    public boolean isWebdavEnabled() {
        return this.getBootstrapManager().isWebdavEnabled();
    }

    public boolean hasAnonymousAccess() {
        return this.permissionManager.hasPermission(null, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
    }

    public List getSpaces() {
        return this.spaces;
    }

    public void setSpaces(List spaces) {
        this.spaces = spaces;
    }

    public List getTypes() {
        return this.types;
    }

    public void setTypes(List types) {
        this.types = types;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getTimeSpan() {
        return this.timeSpan;
    }

    public void setTimeSpan(int timeSpan) {
        this.timeSpan = timeSpan;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public void setSmartListManager(SmartListManager smartListManager) {
    }

    public List getContentList() {
        return this.contentList;
    }

    public void setContentList(List contentList) {
        this.contentList = contentList;
    }

    public String getRssLink() {
        return this.rssLink;
    }

    public void setRssLink(String rssLink) {
        this.rssLink = rssLink;
    }

    public String getRssType() {
        return this.rssType;
    }

    public void setRssType(String rssType) {
        this.rssType = rssType;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public boolean isPublicFeed() {
        return this.publicFeed;
    }

    public void setPublicFeed(boolean publicFeed) {
        this.publicFeed = publicFeed;
    }

    public String getSelectedPublicFeed() {
        return String.valueOf(this.publicFeed);
    }

    public String getAllVersions() {
        return "all";
    }

    public String getLatestVersions() {
        return "latest";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public boolean isShowDiff() {
        return this.showDiff;
    }

    public void setShowDiff(boolean showDiff) {
        this.showDiff = showDiff;
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }
}

