/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.event.EventUtils;
import com.atlassian.confluence.event.events.admin.MailServerCreateEvent;
import com.atlassian.confluence.event.events.admin.MailServerDeleteEvent;
import com.atlassian.confluence.event.events.admin.MailServerEditEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.jmx.JmxUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.mail.server.MailServer;

public class MailServerEventListener
implements EventListener {
    public void handleEvent(Event event) {
        if (!JmxUtil.isPossibleToExposeBeans()) {
            return;
        }
        Event underlyingEvent = EventUtils.extractWrappedEventOrOriginal(event);
        if (underlyingEvent instanceof MailServerCreateEvent) {
            MailServerCreateEvent createEvent = (MailServerCreateEvent)underlyingEvent;
            MailServer server = createEvent.getServer();
            JmxUtil.registerBean(this.makeNameForServer(server.getName()), createEvent.getServer());
        } else if (underlyingEvent instanceof MailServerDeleteEvent) {
            JmxUtil.unregisterBean(this.makeNameForServer(((MailServerDeleteEvent)underlyingEvent).getServer().getName()));
        } else if (underlyingEvent instanceof MailServerEditEvent) {
            MailServerEditEvent editEvent = (MailServerEditEvent)event;
            JmxUtil.unregisterBean(this.makeNameForServer(editEvent.getOriginalServerName()));
            JmxUtil.registerBean(this.makeNameForServer(editEvent.getServer().getName()), editEvent.getServer());
        }
    }

    private String makeNameForServer(String name) {
        return "Confluence:name=MailServer-" + name;
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{ClusterEventWrapper.class, MailServerCreateEvent.class, MailServerDeleteEvent.class, MailServerEditEvent.class};
    }
}

