/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.links.ReferralTask;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.log4j.Category;

public class ReferralListener
implements EventListener {
    private static Category log = Category.getInstance(ReferralListener.class);
    private static Class[] HANDLED_EVENTS = new Class[]{PageViewEvent.class, BlogPostViewEvent.class};
    private TaskQueue referralTaskQueue;
    private AnyTypeObjectDao anyTypeObjectDao;
    private SettingsManager settingsManager;

    public void setReferralTaskQueue(TaskQueue referralTaskQueue) {
        this.referralTaskQueue = referralTaskQueue;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void handleEvent(Event event) {
        String referrer;
        if (log.isDebugEnabled()) {
            if (this.isReferrerTrackingEnabled()) {
                log.debug((Object)("Ignoring referrer event: referrer tracking disabled: " + event));
            } else {
                log.debug((Object)("Received event: " + event));
            }
        }
        if (this.isReferrerTrackingEnabled() && TextUtils.stringSet((String)(referrer = ServletActionContext.getRequest().getHeader("REFERER")))) {
            this.addReferralEvent(event, referrer);
        }
    }

    private void addReferralEvent(Event event, String referrer) {
        Handle handle = this.getHandleFromEvent(event);
        if (handle != null) {
            this.referralTaskQueue.addTask((Task)new ReferralTask(handle, referrer));
        }
    }

    private Handle getHandleFromEvent(Event event) {
        if (event instanceof PageViewEvent) {
            return this.anyTypeObjectDao.getHandle((Object)((PageViewEvent)event).getPage());
        }
        if (event instanceof BlogPostViewEvent) {
            return this.anyTypeObjectDao.getHandle((Object)((BlogPostViewEvent)event).getBlogPost());
        }
        return null;
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    private boolean isReferrerTrackingEnabled() {
        return this.settingsManager.getGlobalSettings().getReferrerSettings().isCollectReferrerData();
    }
}

