/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.event.events.types.Updated;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.ConfluenceTrackbackUtils;
import com.atlassian.confluence.util.task.TrackbackQueueItem;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.trackback.Trackback;
import java.util.List;
import java.util.Set;

public class TrackbackListener
implements EventListener {
    private static Class[] HANDLED_EVENTS = new Class[]{Created.class, Updated.class};
    private LinkResolver linkResolver;
    private SettingsManager settingsManager;
    private MultiQueueTaskManager taskManager;

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void handleEvent(Event event) {
        if (!this.settingsManager.getGlobalSettings().isAllowTrackbacks()) {
            return;
        }
        if (event instanceof ContentEvent) {
            ContentEntityObject ceo = ((ContentEvent)event).getContent();
            List links = this.linkResolver.extractLinks((RenderContext)ceo.toPageContext(), ceo.getContent());
            Set urls = ConfluenceTrackbackUtils.getUrlsFromLinks(links);
            Trackback ping = ConfluenceTrackbackUtils.makeTrackback(ceo);
            this.taskManager.addTask("task", (Task)new TrackbackQueueItem(ping, urls));
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

