/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.importexport.FopConfigurationFactory;
import com.atlassian.confluence.setup.DefaultBootstrapManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.log4j.Category;

public class DefaultFopConfigurationFactory
implements FopConfigurationFactory {
    private static Category log = Category.getInstance(DefaultFopConfigurationFactory.class);
    private static DefaultConfigurationBuilder configBuilder = new DefaultConfigurationBuilder();

    public Configuration getConfiguration() {
        File customFopXml = new File(((DefaultBootstrapManager)BootstrapUtils.getBootstrapManager()).getConfluenceHome() + "/fonts/" + "fop.xml");
        InputStream fopXmlStream = null;
        if (customFopXml.isFile()) {
            try {
                fopXmlStream = new FileInputStream(customFopXml);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e);
            }
        }
        if (fopXmlStream == null) {
            fopXmlStream = ClassLoaderUtils.getResourceAsStream((String)"fop.xml", DefaultFopConfigurationFactory.class);
        }
        try {
            Configuration e = configBuilder.build(fopXmlStream);
            return e;
        }
        catch (Exception e) {
            log.error((Object)"Error building default Configuration to configure FOP.", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.close(fopXmlStream);
        }
    }
}

