/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractImportAction;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractFileRestoreAction
extends AbstractImportAction {
    private static final Logger log = Logger.getLogger(AbstractFileRestoreAction.class);
    private SpaceManager spaceManager;

    protected abstract File getRestoreFile() throws ImportExportException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isImportAllowed() throws ImportExportException, UnexpectedImportZipFileContents {
        Properties exportDescriptorProperties = null;
        try {
            exportDescriptorProperties = ExportUtils.getExportDescriptor(this.getRestoreFile(), true);
        }
        catch (UnexpectedImportZipFileContents e) {
            this.addActionError(e.getMessage());
            return false;
        }
        String exportType = exportDescriptorProperties.getProperty("exportType");
        String exportBuildNumber = exportDescriptorProperties.getProperty("buildNumber");
        if (!TextUtils.stringSet((String)exportType)) {
            this.addActionError(this.getText("error.could.not.determine.export.type"));
            return false;
        }
        if ("page".equals(exportType)) {
            this.addActionError(this.getText("error.cannot.import.backups.here"));
            return false;
        }
        if (!"space".equals(exportType)) return true;
        String spaceKey = ExportUtils.getSpaceKeyFromExportZip(this.getRestoreFile());
        if (spaceKey == null) {
            this.addActionError(this.getText("error.could.not.determine.space.key"));
        }
        if (this.spaceManager.getSpace(spaceKey) != null) {
            this.addActionError(this.getText("error.space.with.key.exists", new Object[]{"'" + spaceKey + "'"}));
        }
        int exportBuildNumberPrefix = this.getPrefixFromBuildNumber(exportBuildNumber);
        int currentBuildNumberPrefix = this.getPrefixFromBuildNumber(GeneralUtil.getBuildNumber());
        if (exportBuildNumberPrefix == -1) return this.getActionErrors().isEmpty();
        if (currentBuildNumberPrefix == -1) return this.getActionErrors().isEmpty();
        if (exportBuildNumberPrefix == currentBuildNumberPrefix) return this.getActionErrors().isEmpty();
        this.addActionError(this.getText("error.restore.backup.different.major.version"));
        return this.getActionErrors().isEmpty();
    }

    private int getPrefixFromBuildNumber(String buildNumber) {
        try {
            return Integer.parseInt(buildNumber.substring(0, buildNumber.length() - 2));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing build number in export descriptor for input String of " + buildNumber + "."));
            return -1;
        }
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

