/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.actions.ExportSpaceLongRunningTask;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class ExportSpaceAction
extends AbstractSpaceAction
implements ServletContextAware {
    private static final String DOWNLOAD = "download";
    private ImportExportManager importExportManager;
    private List availableTypes = null;
    private String type;
    private String downloadPath;
    private boolean includeComments;
    private boolean backupAttachments;
    private List contentToBeExported = new ArrayList();
    private GateKeeper gateKeeper;
    private ContentTree contentTree;
    private ServletContext servletContext;
    private String contentOption;
    private boolean synchronous;

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public List getAvailableTypes() {
        if (this.availableTypes == null) {
            this.availableTypes = new ArrayList();
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-html")), (Serializable)((Object)"TYPE_HTML")));
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-pdf")), (Serializable)((Object)"TYPE_PDF")));
            this.availableTypes.add(new PairType((Serializable)((Object)this.getText("export-xml")), (Serializable)((Object)"TYPE_XML")));
        }
        return this.availableTypes;
    }

    public boolean isIncludeComments() {
        return this.includeComments;
    }

    public void setIncludeComments(boolean includeComments) {
        this.includeComments = includeComments;
    }

    public List getContentToBeExported() {
        return this.contentToBeExported;
    }

    public void setContentToBeExported(List contentToBeExported) {
        this.contentToBeExported = contentToBeExported;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public String doDefault() throws Exception {
        this.includeComments = true;
        this.backupAttachments = true;
        return super.doDefault();
    }

    private boolean isLongRunningTaskSupported() {
        String runningServer = this.getServletContext().getServerInfo().toLowerCase();
        String unsupportedContainers = this.getServletContext().getInitParameter("unsupportedContainersForExportLongRunningTask");
        if (TextUtils.stringSet((String)unsupportedContainers)) {
            String[] containers = unsupportedContainers.split(",");
            for (int i = 0; i < containers.length; ++i) {
                String container = containers[i];
                if (runningServer.indexOf(container = StringUtils.trim((String)container)) == -1) continue;
                return false;
            }
        }
        return true;
    }

    public void validate() {
        super.validate();
        if ("TYPE_XML".equals(this.type) && "all".equals(this.contentOption) && !this.isSpaceAdminOrConfAdmin()) {
            this.addActionError(this.getText("export.space.validation.insufficient.privileges.export.all.content"));
        }
    }

    public String execute() throws Exception {
        DefaultExportContext exportContext = new DefaultExportContext();
        exportContext.setScope("space");
        exportContext.setType(this.getType());
        exportContext.setExportComments(this.isIncludeComments());
        exportContext.setExportAttachments(this.isBackupAttachments());
        exportContext.setUser(this.getRemoteUser());
        exportContext.addWorkingEntity(this.getSpace());
        ExportSpaceLongRunningTask task = new ExportSpaceLongRunningTask(this.getRemoteUser(), ServletContextThreadLocal.getRequest().getContextPath(), exportContext, this.contentToBeExported, this.gateKeeper, this.importExportManager, this.permissionManager, this.type, this.contentOption);
        if (this.isLongRunningTaskSupported() && !this.isSynchronous()) {
            LongRunningTaskUtils.startTask((LongRunningTask)task);
            return "success";
        }
        task.run();
        this.downloadPath = task.getDownloadPath();
        return DOWNLOAD;
    }

    private boolean isSpaceAdminOrConfAdmin() {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, this.space) || this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return ServletActionContext.getServletContext();
    }

    public ContentTree getContentTree() {
        if (this.contentTree == null) {
            this.contentTree = this.importExportManager.getContentTree(this.getRemoteUser(), this.getSpace());
        }
        return this.contentTree;
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("EXPORTSPACE", permissionTypes);
        if (permissionTypes.contains("EDITSPACE")) {
            permissionTypes.remove("EDITSPACE");
        }
        return permissionTypes;
    }

    public boolean isPermitted() {
        return super.isPermitted();
    }

    public boolean isBackupAttachments() {
        return this.backupAttachments;
    }

    public void setBackupAttachments(boolean backupAttachments) {
        this.backupAttachments = backupAttachments;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getContentOption() {
        return this.contentOption;
    }

    public void setContentOption(String contentOption) {
        this.contentOption = contentOption;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

