/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.search.lucene.ConfluenceBatchIndexer;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.spring.container.ContainerManager;

public class ImportLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private ImportExportManager importExportManager;
    private Object type;
    private ImportContext context;

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setType(Object type) {
        this.type = type;
    }

    public void setContext(ImportContext importContext) {
        this.context = importContext;
    }

    public void runInternal() {
        try {
            this.context.setProgressMeter(this.progress);
            this.importExportManager = (ImportExportManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"importExportManager");
            this.importExportManager.importAs(this.type, this.context);
            if (this.context.isRebuildIndex()) {
                ConfluenceBatchIndexer indexer = (ConfluenceBatchIndexer)ContainerManager.getComponent((String)"confluenceBatchIndexer");
                indexer.reIndexAll();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failure during import", (Throwable)e);
            this.progress.setStatus("Import failed. " + e.getMessage());
            this.progress.setCompletedSuccessfully(false);
        }
    }

    public String getName() {
        return "Importing data";
    }

    public String getNameKey() {
        return "import.data.task.name";
    }
}

