/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.AbstractFileRestoreAction;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import java.io.File;

public class RestoreAction
extends AbstractFileRestoreAction {
    protected File getRestoreFile() throws ImportExportException {
        return this.getRestoreFileFromUpload();
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    protected DefaultImportContext createImportContext() throws ImportExportException, UnexpectedImportZipFileContents {
        if (this.getRestoreFileFromUpload() == null) {
            throw new ImportExportException("Error loading restore file.");
        }
        DefaultImportContext defaultImportContext = new DefaultImportContext(this.getRestoreFileFromUpload().getAbsolutePath(), this.getRemoteUser());
        defaultImportContext.setDeleteWorkingFile(true);
        if (ExportUtils.isSpaceImport(this.getRestoreFile())) {
            defaultImportContext.setSpaceKeyOfSpaceImport(ExportUtils.getSpaceKeyFromExportZip(this.getRestoreFile()));
        }
        return defaultImportContext;
    }
}

