/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.actions;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.actions.RestoreAction;
import com.atlassian.confluence.importexport.actions.SetupRestoreHelper;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import java.io.File;
import org.apache.log4j.Logger;

public class SetupRestoreAction
extends RestoreAction {
    private static final Logger log = Logger.getLogger(SetupRestoreAction.class);

    public String execute() throws Exception {
        SetupRestoreHelper.prepareForRestore();
        String result = super.execute();
        if ("success".equals(result)) {
            SetupRestoreHelper.postRestoreSteps();
        }
        return result;
    }

    public boolean isPermitted() {
        return true;
    }

    public void validate() {
        File upload = null;
        try {
            upload = this.getRestoreFileFromUpload();
            String exportType = ExportUtils.getExportTypeFromExportZip(upload, true);
            if (exportType.equals("space")) {
                this.addActionError(this.getText("error.trying.to.restore.space.export"));
            }
        }
        catch (ImportExportException e) {
            log.error((Object)"Could not locate the backup you wish to restore: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Could not unzip uploaded file: [" + upload.getName() + "]. "), (Throwable)e);
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            this.addActionError(unexpectedImportZipFileContents.getMessage());
        }
    }
}

