/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import bucket.user.propertyset.BucketPropertySet;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ConfluencePropertySetManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ObjectHandleTranslator;
import com.atlassian.confluence.importexport.impl.AbstractExporterImpl;
import com.atlassian.confluence.importexport.impl.XMLDatabinder;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class AbstractXmlExporter
extends AbstractExporterImpl {
    public static final String EXPORT_DESCRIPTOR_FILE_NAME = "exportDescriptor.properties";
    public static final String ENTITIES_FILE_NAME = "entities.xml";
    public static final String ATTACHMENTS_DIRECTORY = "attachments";
    public static final String TEMPLATES_DIRECTORY = "velocity";
    protected SessionFactory sessionFactory;
    private SettingsManager settingsManager;
    protected BootstrapManager bootstrapManager;
    protected SpaceManager spaceManager;
    private ConfluencePropertySetManager propertySetManager;
    private PageManager pageManager;
    private MailContentManager mailContentManager;

    protected abstract List getHandlesOfObjectsForExport() throws ImportExportException;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    protected List getObjectsExcludedFromExport() throws ImportExportException {
        if (this.getWorkingExportContext() != null && this.getWorkingExportContext().getExceptionEntities() != null) {
            return this.getWorkingExportContext().getExceptionEntities();
        }
        return new ArrayList();
    }

    public String doExport(ObjectHandleTranslator translator, ProgressMeter progress) throws ImportExportException {
        String baseExportPath = super.doExport(translator, progress);
        this.writeBackupDescriptor(baseExportPath);
        this.backupEverything(translator, progress);
        return baseExportPath;
    }

    protected void backupEverything(ObjectHandleTranslator translator, ProgressMeter progress) throws ImportExportException {
        this.backupEntities(translator, progress);
    }

    protected void writeBackupDescriptor(String baseExportPath) throws ImportExportException {
        Properties descriptorProperties = new Properties();
        descriptorProperties.setProperty("buildNumber", this.bootstrapManager.getBuildNumber());
        descriptorProperties.setProperty("exportType", this.getExportType());
        if (this.getContext() != null) {
            descriptorProperties.setProperty("backupAttachments", Boolean.toString(this.getContext().isExportAttachments()));
        }
        OutputStream os = null;
        try {
            os = this.getDescriptorOutputStream();
            descriptorProperties.store(os, null);
        }
        catch (IOException e) {
            throw new ImportExportException("Couldn't write the exportDescriptor file", e);
        }
        finally {
            IOUtils.close(os);
        }
    }

    protected OutputStream getDescriptorOutputStream() throws ImportExportException, FileNotFoundException {
        return new FileOutputStream(new File(this.getWorkingExportContext().getExportDirectory(), EXPORT_DESCRIPTOR_FILE_NAME));
    }

    protected OutputStream getXmlOutputStream() throws ImportExportException, IOException {
        File destFile = new File(this.getWorkingExportContext().getExportDirectory(), ENTITIES_FILE_NAME);
        destFile.getParentFile().mkdirs();
        destFile.createNewFile();
        return new FileOutputStream(destFile);
    }

    protected String getExportType() throws ImportExportException {
        if (this.getWorkingExportContext() == null) {
            return "all";
        }
        return this.getWorkingExportContext().getScope();
    }

    protected abstract List getSourceTemplateDirForCopying();

    protected void backupEntities(ObjectHandleTranslator translator, ProgressMeter progress) throws ImportExportException {
        BufferedWriter writer = null;
        try {
            String encoding = this.settingsManager.getGlobalSettings().getDefaultEncoding();
            XMLDatabinder databinder = new XMLDatabinder((SessionFactoryImplementor)this.sessionFactory, encoding, translator);
            databinder.setInitializeLazy(true);
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            Transaction tx = session.beginTransaction();
            progress.setStatus("Getting objects to export");
            List objectsForExport = this.getHandlesOfObjectsForExport();
            List excludedObjects = this.getObjectsExcludedFromExport();
            if (this.context != null && !this.context.isExportComments()) {
                excludedObjects.addAll(this.getComments(objectsForExport, translator));
            }
            session.flush();
            session.clear();
            tx.commit();
            databinder.bindAll(objectsForExport);
            databinder.unbindAll(excludedObjects);
            UtilTimerStack.push((String)"toGenericXml()");
            writer = new BufferedWriter(new OutputStreamWriter(this.getXmlOutputStream(), encoding), 32768);
            databinder.toGenericXML(writer, progress);
            UtilTimerStack.pop((String)"toGenericXml()");
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"Couldn't backup database data.", (Throwable)e);
                throw new ImportExportException("Couldn't backup database data.", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close(writer);
    }

    private List getComments(List objectsForExport, ObjectHandleTranslator translator) {
        ArrayList<Object> allComments = new ArrayList<Object>();
        for (Object o : objectsForExport) {
            if (o instanceof TransientHibernateHandle) {
                TransientHibernateHandle handle = (TransientHibernateHandle)o;
                o = translator.handleToObject(handle);
            }
            if (!Page.class.isAssignableFrom(o.getClass())) continue;
            Page p = (Page)o;
            List<Comment> comments = p.getComments();
            Iterator<Comment> commIt = comments.iterator();
            while (commIt.hasNext()) {
                allComments.add(translator.objectToHandle(commIt.next()));
            }
        }
        return allComments;
    }

    protected List expandSpaces(List workingEntities) {
        ArrayList entitiesForExport = new ArrayList();
        for (int i = 0; i < workingEntities.size(); ++i) {
            ConfluenceEntityObject content = (ConfluenceEntityObject)workingEntities.get(i);
            if (!(content instanceof Space)) continue;
            entitiesForExport.addAll(this.getContentAndContentPropertiesFromSpace((Space)content));
        }
        return entitiesForExport;
    }

    protected List getContentAndContentPropertiesFromSpace(Space space) {
        ArrayList<ContentEntityObject> result = new ArrayList<ContentEntityObject>();
        ArrayList contentList = new ArrayList();
        List pages = this.pageManager.getPages(space, false);
        if (!this.getWorkingExportContext().isExportAll() && this.getWorkingExportContext().getContentTree() != null) {
            List permittedPages = this.getWorkingExportContext().getContentTree().getPages();
            for (Page page : pages) {
                if (page.isLatestVersion() && !permittedPages.contains(page)) {
                    this.getWorkingExportContext().addExceptionEntity(page);
                }
                if (page.isLatestVersion() || permittedPages.contains(page.getOriginalVersion())) continue;
                this.getWorkingExportContext().addExceptionEntity(page);
            }
        }
        contentList.addAll(pages);
        contentList.addAll(this.pageManager.getBlogPosts(space, false));
        contentList.addAll(this.mailContentManager.getMail(space, false));
        for (ContentEntityObject contentObject : contentList) {
            result.add(contentObject);
            this.addPropertiesForContent(result, contentObject);
        }
        return result;
    }

    protected void addPropertiesForContent(List contentList, ContentEntityObject contentObject) {
        BucketPropertySet propertySet = (BucketPropertySet)this.propertySetManager.getPropertySet(contentObject);
        Iterator keys = propertySet.getKeys().iterator();
        while (keys.hasNext()) {
            contentList.add(propertySet.getByKey((String)keys.next()));
        }
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPropertySetManager(ConfluencePropertySetManager propertySetManager) {
        this.propertySetManager = propertySetManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }
}

