/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.cache.CacheManager;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.admin.ImportFinishedEvent;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.Importer;
import com.atlassian.confluence.importexport.impl.ReverseDatabinder;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.DefaultHibernateConfigurator;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.upgrade.GuardPermissionsUpgradeTask;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.log4j.Category;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class BackupImporter
extends Importer {
    protected static final Category log = Category.getInstance(BackupImporter.class);
    protected PageManager pageManager;
    protected LabelManager labelManager;
    protected EventManager eventManager;
    protected SpaceManager spaceManager;
    protected CacheManager cacheManager;
    protected UserAccessor userAccessor;
    protected BandanaPersister bandanaPersister;
    protected SchemaHelper schemaHelper;
    private boolean backupAttachments = true;
    protected BootstrapManager bootstrapManager;
    private SpacePermissionManager spacePermissionManager;
    private ConfluenceIndexManager indexManager;
    protected AttachmentManager attachmentManager;
    private Scheduler scheduler;
    protected I18NBeanFactory i18NBeanFactory;
    Properties descriptorProperties;
    private Boolean incrementalImport = null;

    public void setIncrementalImport(Boolean value) {
        this.incrementalImport = value;
    }

    public void doImport() throws ImportExportException {
        if (!this.isIncrementalImport()) {
            this.unIndexAll();
        }
        try {
            this.scheduler.standby();
            this.importEverything();
            if (!this.isIncrementalImport() && TextUtils.stringSet((String)this.getBuildNumberOfImport())) {
                this.doUpgrades();
            }
            this.spacePermissionManager.flushCaches();
            if (this.context.isDeleteWorkingFile() && this.context.getWorkingFile() != null) {
                new File(this.context.getWorkingFile()).delete();
            }
            this.eventManager.publishEvent((Event)new ImportFinishedEvent(this, this.context));
        }
        catch (SchedulerException e) {
            throw new ImportExportException(this.getText("backup.importer.scheduler.standby.error"), e);
        }
        finally {
            try {
                if (this.scheduler.isInStandbyMode()) {
                    this.scheduler.start();
                }
            }
            catch (SchedulerException e) {
                throw new ImportExportException(this.getText("backup.importer.scheduler.restart.error"), e);
            }
        }
    }

    private void doUpgrades() throws ImportExportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            int buildNumber = Integer.parseInt(this.getBuildNumberOfImport());
            if (buildNumber < 58) {
                new GuardPermissionsUpgradeTask().doUpgrade();
            }
            if (buildNumber < 59) {
                ((UpgradeTask)ContainerManager.getComponent((String)"purgeThumbnailsUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 60) {
                ((UpgradeTask)ContainerManager.getComponent((String)"attachmentSizeUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 103) {
                ((UpgradeTask)ContainerManager.getComponent((String)"newSpacePermissionsUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 122) {
                ((UpgradeTask)ContainerManager.getComponent((String)"purgeCorruptOutgoingLinksUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 201) {
                ((UpgradeTask)ContainerManager.getComponent((String)"pagePermissionUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 204) {
                ((UpgradeTask)ContainerManager.getComponent((String)"dailyReportPreferenceUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 206) {
                ((UpgradeTask)ContainerManager.getComponent((String)"excerptMacroUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 217) {
                ((UpgradeTask)ContainerManager.getComponent((String)"hashTaskListKeysUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 218) {
                ((UpgradeTask)ContainerManager.getComponent((String)"duplicateNotificationsCleanupUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 508) {
                ((UpgradeTask)ContainerManager.getComponent((String)"setGlobalSpaceTypeUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 605) {
                ((UpgradeTask)ContainerManager.getComponent((String)"moveLayoutsToDatabaseUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 629) {
                ((UpgradeTask)ContainerManager.getComponent((String)"introduceShortcutLinkAliasUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 702) {
                ((UpgradeTask)ContainerManager.getComponent((String)"legacyContentPermissionUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 810) {
                ((UpgradeTask)ContainerManager.getComponent((String)"initialiseSidUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 1012) {
                ((UpgradeTask)ContainerManager.getComponent((String)"osUserToAtlassianUserMigrationUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 1101) {
                ((UpgradeTask)ContainerManager.getComponent((String)"convertAdministerConfluenceToSystemAdministratorUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 1103) {
                ((UpgradeTask)ContainerManager.getComponent((String)"initApplicationKeysUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 1404) {
                ((UpgradeTask)ContainerManager.getComponent((String)"changeLogoStorageUpgradeTask")).doUpgrade();
            }
            if (buildNumber < 1419) {
                ((UpgradeTask)ContainerManager.getComponent((String)"rebuildAncestorsUpgradeTask")).doUpgrade();
            }
            try {
                session.flush();
            }
            catch (HibernateException e) {
                throw new ImportExportException("Import failed flushing session to database", e);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Could not determine whether data upgrade was necessary from backup build number: " + this.getBuildNumberOfImport()));
        }
        catch (Exception e) {
            log.error((Object)("Error while upgrading imported data " + e.getMessage()), (Throwable)e);
            throw new ImportExportException("Error while upgrading imported data " + e.getMessage(), e);
        }
    }

    protected void importEverything() throws ImportExportException {
        this.importEntities(this.createXmlReader(), this.spaceManager, false);
        this.resetIdentifierGenerators();
    }

    protected void importEverything(ReverseDatabinder xmlReader, boolean hasExtraToImport) throws ImportExportException {
        this.importEntities(xmlReader, this.spaceManager, hasExtraToImport);
        this.resetIdentifierGenerators();
    }

    protected ReverseDatabinder createXmlReader() throws ImportExportException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        return new ReverseDatabinder((SessionFactoryImplementor)this.sessionFactory, (SessionImplementor)session, !this.isIncrementalImport(), this.labelManager);
    }

    private void resetIdentifierGenerators() throws ImportExportException {
        try {
            ((UpgradeTask)ContainerManager.getComponent((String)"hiLoIdRepairUpgradeTask")).doUpgrade();
        }
        catch (Exception e) {
            throw new ImportExportException("Error adjusting the hibernat_unique_key.next_hi value", e);
        }
    }

    protected void importEntities(ReverseDatabinder xmlReader, SpaceManager spaceManager, boolean hasExtraToImport) throws ImportExportException {
        try {
            ProgressMeter meter = this.context.getProgressMeter();
            meter.setPercentage(0);
            Session s = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
            if (s != null) {
                try {
                    s.flush();
                    s.connection().commit();
                }
                catch (HibernateException he) {
                    log.error((Object)"error flushing session", (Throwable)he);
                }
                catch (SQLException sqle) {
                    log.error((Object)"error commiting connection", (Throwable)sqle);
                }
            }
            if (!this.isIncrementalImport()) {
                meter.setStatus("Deleting existing content.");
                this.deleteAllDatabaseContent();
            }
            if (s != null) {
                try {
                    s.flush();
                    s.connection().commit();
                }
                catch (HibernateException he) {
                    log.error((Object)"error flushing session", (Throwable)he);
                }
                catch (SQLException sqle) {
                    log.error((Object)"error commiting connection", (Throwable)sqle);
                }
            }
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
            session.clear();
            xmlReader.fromXML(this, session, meter);
            int count = 0;
            meter.setStatus("Applying special processing");
            meter.setTotalObjects(meter.getCurrentCount() + xmlReader.getWrittenIds().size());
            Transaction tx = session.beginTransaction();
            for (TransientHibernateHandle id : xmlReader.getWrittenIds()) {
                log.debug((Object)("Applying special processing on " + id));
                this.doSpecialProcessing(session, id, spaceManager);
                if (this.context.getPostProcessor() != null) {
                    Object obj = id.get(session);
                    try {
                        if (this.context.getPostProcessor().process(obj)) {
                            session.update(obj);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Postprocessing failed on " + obj + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                if (++count % 100 != 0) continue;
                tx.commit();
                tx = session.beginTransaction();
                meter.setCurrentCount(meter.getCurrentCount() + 100);
            }
            tx.commit();
            this.cacheManager.flushCaches();
            if (hasExtraToImport) {
                meter.setPercentage(90);
                meter.setStatus("Entities loaded...");
            } else {
                this.completeProgessMeter();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot import the entities:", (Throwable)e);
            throw new ImportExportException(e);
        }
    }

    protected void completeProgessMeter() {
        ProgressMeter meter = this.context.getProgressMeter();
        meter.setPercentage(100);
        meter.setStatus("Complete.");
    }

    protected void doSpecialProcessing(Session session, TransientHibernateHandle key, SpaceManager spaceManager) throws ImportExportException, HibernateException {
        Labelling labelling;
        if (ContentEntityObject.class.isAssignableFrom(key.getClazz())) {
            ContentEntityObject entityObject = (ContentEntityObject)key.get(session);
            boolean changed = false;
            Iterator it = entityObject.getAttachments().iterator();
            while (it.hasNext()) {
                Attachment att = (Attachment)it.next();
                if (TextUtils.stringSet((String)att.getFileName())) continue;
                it.remove();
                session.delete((Object)att);
                changed = true;
            }
            it = entityObject.getOutgoingLinks().iterator();
            while (it.hasNext()) {
                OutgoingLink link = (OutgoingLink)it.next();
                if (TextUtils.stringSet((String)link.getDestinationSpaceKey())) continue;
                it.remove();
                changed = true;
            }
            if (entityObject instanceof Page) {
                Space s;
                Page page = (Page)entityObject;
                Space defaultSpace = ((DefaultImportContext)this.context).getDefaultSpace();
                if (page.getSpace() == null && page.isLatestVersion() && defaultSpace != null && (s = spaceManager.getSpace(defaultSpace.getKey())) != null) {
                    page.setSpace(s);
                    changed = true;
                }
                if (page.getParent() != null && page.getParent().getId() == page.getId()) {
                    log.error((Object)"Detected page with self as its parent. Removing relationship.");
                    page.setParentPage(null);
                    changed = true;
                }
            }
            if (changed) {
                session.update((Object)entityObject);
            }
        } else if (this.isIncrementalImport() && Space.class.isAssignableFrom(key.getClazz())) {
            Space space = (Space)key.get(session);
            boolean changed = false;
            Iterator iter = space.getPermissions().iterator();
            while (iter.hasNext()) {
                SpacePermission permission = (SpacePermission)iter.next();
                if (!this.isSpacePermissionUnknown(permission)) continue;
                permission.setSpace(space);
                iter.remove();
                session.delete((Object)permission);
                changed = true;
            }
            if (changed) {
                session.update((Object)space);
            }
        } else if (OutgoingLink.class.isAssignableFrom(key.getClazz())) {
            OutgoingLink link = (OutgoingLink)key.get(session);
            if (!TextUtils.stringSet((String)link.getDestinationSpaceKey())) {
                session.delete((Object)link);
            } else {
                String destinationPageTitle = link.getDestinationPageTitle();
                if (destinationPageTitle == null || destinationPageTitle.trim().length() == 0) {
                    link.setDestinationPageTitle("unknown");
                    session.update((Object)link);
                }
            }
        } else if (ReferralLink.class.isAssignableFrom(key.getClazz())) {
            ReferralLink link = (ReferralLink)key.get(session);
            if (link.getUrl() == null) {
                link.setUrl("");
                session.update((Object)link);
            }
        } else if (Labelling.class.isAssignableFrom(key.getClazz()) && ((labelling = (Labelling)key.get(session)).getContent() == null || labelling.getLabel() == null || labelling.getSpaceKey() == null)) {
            log.warn((Object)("Deleting invalid labelling [" + labelling + "]"));
            session.delete((Object)labelling);
        }
    }

    private boolean isSpacePermissionUnknown(SpacePermission permission) {
        String groupName = permission.getGroup();
        String userName = permission.getUserName();
        return groupName != null && this.userAccessor.getGroup(groupName) == null || userName != null && this.userAccessor.getUser(userName) == null;
    }

    public void deleteAllDatabaseContent() throws HibernateException, SQLException, ConfigurationException {
        DefaultHibernateConfigurator.createConfluenceSchema(this.schemaHelper.getConfiguration());
        this.cacheManager.flushCaches();
    }

    protected void unIndexAll() {
        this.indexManager.unIndexAll();
    }

    public Properties getDescriptorProperties() throws ImportExportException {
        this.descriptorProperties = GeneralUtil.getPropertiesFromStream(this.getDescriptorPropertiesStream());
        return this.descriptorProperties;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setBandanaPersister(BandanaPersister bandanaPersister) {
        this.bandanaPersister = bandanaPersister;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    public String getExportType() throws ImportExportException {
        return this.getDescriptorProperties().getProperty("exportType");
    }

    public boolean isBackupAttachments() throws ImportExportException {
        String backupAttachmentsProperty = this.getDescriptorProperties().getProperty("backupAttachments");
        if (TextUtils.stringSet((String)backupAttachmentsProperty)) {
            this.backupAttachments = Boolean.valueOf(backupAttachmentsProperty);
        }
        return this.backupAttachments;
    }

    public String getBuildNumberOfImport() throws ImportExportException {
        return this.getDescriptorProperties().getProperty("buildNumber");
    }

    public boolean isIncrementalImport() throws ImportExportException {
        if (this.incrementalImport == null) {
            boolean isImportTypeIncremental;
            boolean isIncrementalImportSetToTrue = this.context instanceof DefaultImportContext && ((DefaultImportContext)this.context).isIncrementalImport();
            boolean bl = isImportTypeIncremental = this.getExportType() != null && !this.getExportType().equalsIgnoreCase("all");
            if (this.getExportType() == null) {
                File backupedFilePath = new File(this.context.getWorkingFile());
                isImportTypeIncremental = !backupedFilePath.getName().startsWith("export-");
            }
            this.incrementalImport = isIncrementalImportSetToTrue || isImportTypeIncremental;
        }
        return this.incrementalImport;
    }

    private String getText(String key) {
        try {
            I18NBean i18nBean = this.i18NBeanFactory.getI18NBean();
            return i18nBean.getText(key);
        }
        catch (Exception t) {
            log.error((Object)("Erroring translating i18n key: " + key), (Throwable)t);
            return key;
        }
    }

    protected abstract InputStream getDescriptorPropertiesStream() throws ImportExportException;

    public abstract InputStream getXmlEntitiesStream() throws ImportExportException;

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setIndexManager(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }
}

